/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.util;

import joshie.harvest.api.HFApi;
import joshie.harvest.api.core.ISizeable;
import joshie.harvest.api.core.ISizedProvider;
import joshie.harvest.api.crops.ICrop;
import joshie.harvest.core.util.SafeStack;
import net.minecraft.item.ItemStack;

public class HFStack
extends SafeStack {
    private ICrop crop;
    private ISizeable sized;

    public HFStack(ItemStack stack) {
        super(stack);
        if (HFApi.CROPS.getCropFromStack(stack) != null) {
            this.crop = HFApi.CROPS.getCropFromStack(stack);
        } else if (stack.func_77973_b() instanceof ISizedProvider) {
            this.sized = ((ISizedProvider)stack.func_77973_b()).getSizeable(stack);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HFStack other = (HFStack)obj;
        if (this.crop != null && other.crop == null) {
            return false;
        }
        if (this.sized != null && other.sized == null) {
            return false;
        }
        if (this.crop != null) {
            return this.crop.equals(other.crop);
        }
        if (this.sized != null) {
            return this.sized.equals(other.sized);
        }
        return true;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.crop == null ? 0 : this.crop.hashCode());
        result = 31 * result + (this.sized == null ? 0 : this.sized.hashCode());
        return result;
    }
}

