/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import joshie.harvest.HarvestFestival;
import joshie.harvest.core.helpers.ConfigHelper;
import joshie.harvest.core.util.HFCaches;
import joshie.harvest.core.util.HFEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.IModGuiFactory;
import net.minecraftforge.fml.client.config.DummyConfigElement;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@HFEvents(value=Side.CLIENT)
public class HFGuiFactory
implements IModGuiFactory {
    public void initialize(Minecraft minecraftInstance) {
    }

    public Class<? extends GuiScreen> mainConfigGuiClass() {
        return GuiHFConfig.class;
    }

    public Set<IModGuiFactory.RuntimeOptionCategoryElement> runtimeGuiCategories() {
        return null;
    }

    public IModGuiFactory.RuntimeOptionGuiHandler getHandlerFor(IModGuiFactory.RuntimeOptionCategoryElement element) {
        return null;
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("harvestfestival")) {
            Configuration config = ConfigHelper.getConfig();
            if (config.hasChanged()) {
                config.save();
            }
            HarvestFestival.proxy.configure();
            HFCaches.clearClient();
        }
    }

    public static class GuiHFConfig
    extends GuiConfig {
        public GuiHFConfig(GuiScreen parentScreen) {
            super(parentScreen, GuiHFConfig.getConfigElements(), "harvestfestival", false, true, GuiConfig.getAbridgedConfigPath((String)ConfigHelper.getConfig().toString()));
        }

        private static List<IConfigElement> getConfigElements() {
            ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
            ArrayList<Class> configsList = new ArrayList<Class>(HarvestFestival.proxy.getList());
            Collections.sort(configsList, (c1, c2) -> c1.getSimpleName().compareTo(c2.getSimpleName()));
            for (Class c : configsList) {
                try {
                    Method configure = c.getMethod("configure", new Class[0]);
                    if (configure == null) continue;
                    String categoryName = c.getSimpleName().replace("HF", "");
                    List configElements = new ConfigElement(ConfigHelper.getConfig().getCategory(categoryName)).getChildElements();
                    list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement(categoryName, "harvestfestival.config", configElements));
                }
                catch (Exception exception) {}
            }
            return list;
        }
    }
}

