/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.util;

import java.io.File;
import java.io.PrintWriter;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import org.apache.commons.io.FileUtils;

public class CodeGeneratorRendering {
    public void getCode() {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("package joshie.harvest.blocks.render;\n\n");
            builder.append("import joshie.harvest.util.RenderBase;\n");
            builder.append("import net.minecraft.init.Blocks;\n");
            builder.append("import net.minecraft.util.EnumFacing;\n\n");
            builder.append("import org.lwjgl.opengl.GL11;\n\n");
            builder.append("public class RenderFridge extends RenderBase {\n");
            builder.append("    @Override\n");
            builder.append("    public void renderBlock() {\n");
            String input = FileUtils.readFileToString((File)new File("render-input.txt"));
            builder.append("        if (dir == EnumFacing.WEST || isItem()) {\n");
            builder.append(input);
            builder.append("\n        } else if (dir == EnumFacing.NORTH) {");
            builder.append("\n" + input.replaceAll("\\((.*),\\s(.*),\\s(.*),\\s(.*),\\s(.*),\\s(.*)\\)", "\\($3, $2, $1, $6, $5, $4\\)"));
            builder.append("\n        } else if (dir == EnumFacing.EAST) {");
            StringBuilder second = new StringBuilder("");
            String[] split = input.split(",|;");
            int pos = 0;
            double one = 0.0;
            double two = 0.0;
            double three = 0.0;
            double four = 0.0;
            double five = 0.0;
            double six = 0.0;
            DecimalFormat df = new DecimalFormat("#.###");
            df.setRoundingMode(RoundingMode.DOWN);
            for (String s : split) {
                if (s.contains("setTexture")) {
                    second.append(s).append(";");
                    continue;
                }
                String trimmed = s.replace("renderBlock(", "").replace(")", "");
                Double value = Double.parseDouble(trimmed);
                switch (pos) {
                    case 0: {
                        one = value;
                        break;
                    }
                    case 1: {
                        two = value;
                        break;
                    }
                    case 2: {
                        three = value;
                        break;
                    }
                    case 3: {
                        four = value;
                        break;
                    }
                    case 4: {
                        five = value;
                        break;
                    }
                    case 5: {
                        six = value;
                    }
                }
                if (++pos != 6) continue;
                StringBuilder append = new StringBuilder("\n           renderBlock(");
                append.append("" + df.format(1.0 - four) + "D, ");
                append.append("" + two + "D, ");
                append.append("" + three + "D, ");
                append.append("" + df.format(1.0 - one) + "D, ");
                append.append("" + five + "D, ");
                append.append("" + six + "D);");
                second.append((CharSequence)append);
                pos = 0;
            }
            builder.append((CharSequence)second);
            builder.append("\n        } else if (dir == EnumFacing.SOUTH) {");
            builder.append(second.toString().replaceAll("\\((.*),\\s(.*),\\s(.*),\\s(.*),\\s(.*),\\s(.*)\\)", "\\($3, $2, $1, $6, $5, $4\\)"));
            builder.append("\n        }\n");
            builder.append("    }\n");
            builder.append("}\n");
            PrintWriter writer = new PrintWriter("render-generator.log", "UTF-8");
            writer.print(builder.toString());
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

