/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.util;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import joshie.harvest.api.HFApi;
import joshie.harvest.buildings.placeable.PlaceableHelper;
import joshie.harvest.core.util.generic.IFaceable;
import joshie.harvest.npc.entity.EntityNPC;
import joshie.harvest.npc.entity.EntityNPCBuilder;
import joshie.harvest.npc.entity.EntityNPCShopkeeper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class CodeGeneratorBuildings {
    private World world;
    private int x1;
    private int y1;
    private int z1;
    private int x2;
    private int y2;
    private int z2;

    public CodeGeneratorBuildings(World world, int xStart, int yStart, int zStart, int xEnd, int yEnd, int zEnd) {
        this.world = world;
        this.x1 = xStart < xEnd ? xStart : xEnd;
        this.x2 = xStart < xEnd ? xEnd : xStart;
        this.y1 = yStart < yEnd ? yStart : yEnd;
        this.y2 = yStart < yEnd ? yEnd : yStart;
        this.z1 = zStart < zEnd ? zStart : zEnd;
        this.z2 = zStart < zEnd ? zEnd : zStart;
    }

    public ArrayList<Entity> getEntities(Class clazz, int x, int y, int z) {
        return (ArrayList)this.world.func_72872_a(clazz, new AxisAlignedBB(new BlockPos(x, y, z)));
    }

    public void getCode(boolean air) {
        if (!this.world.field_72995_K) {
            ArrayList<String> ret = new ArrayList<String>();
            HashSet<Entity> all = new HashSet<Entity>();
            int i = 0;
            for (int y = 0; y <= this.y2 - this.y1; ++y) {
                for (int x = 0; x <= this.x2 - this.x1; ++x) {
                    for (int z = 0; z <= this.z2 - this.z1; ++z) {
                        HashSet<Entity> entityList = new HashSet<Entity>();
                        entityList.addAll(this.getEntities(EntityPainting.class, this.x1 + x, this.y1 + y, this.z1 + z));
                        entityList.addAll(this.getEntities(EntityItemFrame.class, this.x1 + x, this.y1 + y, this.z1 + z));
                        entityList.addAll(this.getEntities(EntityNPC.class, this.x1 + x, this.y1 + y, this.z1 + z));
                        entityList.addAll(this.getEntities(EntityNPCBuilder.class, this.x1 + x, this.y1 + y, this.z1 + z));
                        entityList.addAll(this.getEntities(EntityNPCShopkeeper.class, this.x1 + x, this.y1 + y, this.z1 + z));
                        BlockPos position = new BlockPos(this.x1 + x, this.y1 + y, this.z1 + z);
                        IBlockState state = this.world.func_180495_p(position);
                        Block block = state.func_177230_c();
                        if (block == Blocks.field_150486_ae) {
                            String name;
                            TileEntityChest chest = (TileEntityChest)this.world.func_175625_s(new BlockPos(this.x1 + x, this.y1 + y, this.z1 + z));
                            String field = name = chest.func_70005_c_();
                            if (name.startsWith("npc.")) {
                                field = name.replace("npc.", "");
                                ret.add(PlaceableHelper.getPlaceableEntityString((Entity)new EntityNPC(null, this.world, HFApi.NPC.get(field)), (BlockPos)new BlockPos(x, y, z)));
                            }
                            String text = "npc_offsets.put(Town." + field.toUpperCase() + ", new PlaceableNPC(\"\", " + x + ", " + y + ", " + z + "));";
                            ret.add(text);
                            String air2 = PlaceableHelper.getPlaceableBlockString((IBlockState)state, (BlockPos)new BlockPos(x, y, z));
                            ret.add(air2);
                            continue;
                        }
                        if (block == Blocks.field_150350_a && !air && entityList.size() <= 0 || block == Blocks.field_150377_bs) continue;
                        int meta = state.func_177230_c().func_176201_c(state);
                        if (block == Blocks.field_150398_cm && meta >= 8) continue;
                        TileEntity tile = this.world.func_175625_s(position);
                        if (tile instanceof IFaceable) {
                            ret.add(PlaceableHelper.getPlaceableIFaceableString((IFaceable)((IFaceable)tile), (IBlockState)state, (BlockPos)new BlockPos(x, y, z)));
                        } else if (tile instanceof TileEntitySign) {
                            ITextComponent[] text = ((TileEntitySign)tile).field_145915_a;
                            if (block == Blocks.field_150472_an) {
                                ret.add(PlaceableHelper.getFloorSignString((ITextComponent[])text, (IBlockState)state, (BlockPos)new BlockPos(x, y, z)));
                            } else {
                                ret.add(PlaceableHelper.getWallSignString((ITextComponent[])text, (IBlockState)state, (BlockPos)new BlockPos(x, y, z)));
                            }
                        } else {
                            String text = PlaceableHelper.getPlaceableBlockString((IBlockState)state, (BlockPos)new BlockPos(x, y, z));
                            text = text.replace("schematicmetablocks:blockImplicitAir", "air");
                            text = text.replace("schematicmetablocks:blockInteriorAirMarker", "air");
                            text = text.replace("schematicmetablocks:blockExplicitAir", "air");
                            ret.add(text);
                        }
                        if (entityList.size() > 0) {
                            int l = 0;
                            for (Entity e : entityList) {
                                if (!all.contains(e)) {
                                    ret.add(PlaceableHelper.getPlaceableEntityString((Entity)e, (BlockPos)new BlockPos(x, y, z)));
                                    all.add(e);
                                }
                                ++l;
                            }
                        }
                        ++i;
                    }
                }
            }
            ArrayList<String> build = new ArrayList<String>();
            build.add("list = new ArrayList(" + i + ");");
            build.addAll(ret);
            try {
                PrintWriter writer = new PrintWriter("building-generator.log", "UTF-8");
                for (String s : build) {
                    writer.println(s);
                }
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

