/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.tile;

import java.util.UUID;
import joshie.harvest.api.HFApi;
import joshie.harvest.core.base.tile.TileFaceable;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.player.PlayerTrackerServer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class TileShipping
extends TileFaceable {
    private UUID owner;
    private final IItemHandler handler = new EmptyHandler(){

        public int getSlots() {
            return 1;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack == null || stack.func_77973_b() == null || TileShipping.this.owner == null) {
                return stack;
            }
            long sell = HFApi.shipping.getSellValue(stack);
            if (sell > 0L) {
                if (!simulate && !TileShipping.this.func_145831_w().field_72995_K) {
                    PlayerTrackerServer tracker = (PlayerTrackerServer)HFTrackers.getPlayerTracker(TileShipping.this.func_145831_w(), TileShipping.this.owner);
                    if (tracker != null) {
                        tracker.getTracking().addForShipping(stack.func_77946_l());
                    } else {
                        return stack;
                    }
                }
                ItemStack copy = stack.func_77946_l();
                copy.func_77979_a(1);
                return copy;
            }
            return stack;
        }
    };

    public void setOwner(UUID uuid) {
        this.owner = uuid;
        this.func_70296_d();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74779_i("Owner") != null) {
            this.owner = UUID.fromString(nbt.func_74779_i("Owner"));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        if (this.owner != null) {
            nbt.func_74778_a("Owner", this.owner.toString());
        }
        return super.func_189515_b(nbt);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.handler;
        }
        return (T)super.getCapability(capability, facing);
    }
}

