/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.registry;

import joshie.harvest.api.core.IShippable;
import joshie.harvest.api.core.IShippingRegistry;
import joshie.harvest.api.core.Ore;
import joshie.harvest.core.util.annotations.HFApiImplementation;
import joshie.harvest.core.util.holders.HolderRegistry;
import net.minecraft.item.ItemStack;

@HFApiImplementation
public class ShippingRegistry
implements IShippingRegistry {
    public static final ShippingRegistry INSTANCE = new ShippingRegistry();
    public static final String SELL_VALUE = "SellValue";
    private final HolderRegistry<Long> registry = new HolderRegistry();

    private ShippingRegistry() {
    }

    public HolderRegistry<Long> getRegistry() {
        return this.registry;
    }

    @Override
    public void registerSellable(ItemStack stack, long value) {
        this.registry.register(stack, value);
    }

    @Override
    public void registerSellable(Ore ore, long value) {
        this.registry.register(ore, value);
    }

    @Override
    public long getSellValue(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74763_f(SELL_VALUE);
        }
        Long value = this.registry.getValueOf(stack);
        if (value != null) {
            return value;
        }
        if (stack.func_77973_b() instanceof IShippable) {
            return ((IShippable)stack.func_77973_b()).getSellValue(stack);
        }
        return 0L;
    }
}

