/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.proxy;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import joshie.harvest.HarvestFestival;
import joshie.harvest.core.HFApiLoader;
import joshie.harvest.core.helpers.ConfigHelper;
import joshie.harvest.core.util.annotations.HFLoader;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.Level;

public class HFCommonProxy {
    private static final List<Class> LIST = new ArrayList<Class>();
    private static final boolean ENABLE_LOGGING = true;

    public List<Class> getList() {
        return LIST;
    }

    public void setup(@Nonnull ASMDataTable table) {
        ArrayList<Triple> unsorted = new ArrayList<Triple>();
        HashSet datas = new HashSet(table.getAll(HFLoader.class.getCanonicalName()));
        for (ASMDataTable.ASMData data : datas) {
            try {
                String mods;
                String clazz = data.getClassName();
                Map map = data.getAnnotationInfo();
                String string = mods = map.get("mods") != null ? (String)map.get("mods") : "";
                int value = mods.equals("") ? (map.get("priority") != null ? (Integer)map.get("priority") : 1) : -5000;
                unsorted.add(Triple.of((Object)value, (Object)mods, (Object)clazz));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Comparator<Triple<Integer, String, String>> priority = new Comparator<Triple<Integer, String, String>>(){

            @Override
            public int compare(Triple<Integer, String, String> str1, Triple<Integer, String, String> str2) {
                return (Integer)str1.getLeft() < (Integer)str2.getLeft() ? 1 : ((Integer)str1.getLeft() > (Integer)str2.getLeft() ? -1 : 0);
            }
        };
        Collections.sort(unsorted, priority);
        block5: for (Triple entry : unsorted) {
            try {
                if (!((String)entry.getMiddle()).equals("")) {
                    String[] mods;
                    for (String mod : mods = ((String)entry.getMiddle()).replace(" ", "").split(",")) {
                        if (!this.isModLoaded(mod)) continue block5;
                    }
                }
                LIST.add(Class.forName((String)entry.getRight()));
            }
            catch (Exception e) {
                HarvestFestival.LOGGER.log(Level.ERROR, "Harvest Festival failed to load the following class: " + (String)entry.getMiddle());
                HarvestFestival.LOGGER.log(Level.ERROR, "If this a mod related class, try updating your version of that mod before reporting");
            }
        }
    }

    private boolean isModLoaded(String mod) {
        return Loader.isModLoaded((String)mod) || Loader.isModLoaded((String)mod.toLowerCase(Locale.ENGLISH));
    }

    public void setupConfig(File file) {
        ConfigHelper.setConfig(new Configuration(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure() {
        Configuration config = ConfigHelper.getConfig();
        for (Class c : LIST) {
            try {
                Method configure = c.getMethod("configure", new Class[0]);
                ConfigHelper.setCategory(c.getSimpleName().replace("HF", ""));
                try {
                    config.load();
                    configure.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
                finally {
                    if (!config.hasChanged()) continue;
                    config.save();
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
    }

    public void load(String stage) {
        for (Class c : LIST) {
            try {
                c.getMethod(stage, new Class[0]).invoke(null, new Object[0]);
            }
            catch (NoClassDefFoundError | NoSuchMethodException throwable) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!this.isClient()) continue;
            try {
                c.getMethod(stage + "Client", new Class[0]).invoke(null, new Object[0]);
            }
            catch (NoClassDefFoundError | NoSuchMethodException e) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isClient() {
        return false;
    }

    public void loadAPI(ASMDataTable data) {
        HFApiLoader.load(data, this.isClient());
    }
}

