/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.network.quests;

import io.netty.buffer.ByteBuf;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.quest.IQuest;
import joshie.harvest.core.helpers.QuestHelper;
import joshie.harvest.core.helpers.generic.MCClientHelper;
import joshie.harvest.core.network.penguin.PenguinPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PacketQuestSetStage
extends PenguinPacket {
    private IQuest quest;
    private int stage;

    public PacketQuestSetStage() {
    }

    public PacketQuestSetStage(IQuest quest, int stage) {
        this.quest = quest;
        this.stage = stage;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeShort(this.stage);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.quest.getUniqueName());
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.stage = buf.readShort();
        this.quest = HFApi.QUESTS.get(ByteBufUtils.readUTF8String((ByteBuf)buf));
    }

    @Override
    public void handlePacket(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            QuestHelper.setQuestStage(player, this.quest, this.stage);
        } else {
            QuestHelper.setQuestStage(MCClientHelper.getPlayer(), this.quest, this.stage);
        }
    }
}

