/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.network.penguin;

import com.google.common.io.CharStreams;
import io.netty.buffer.ByteBuf;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import joshie.harvest.core.helpers.generic.MCClientHelper;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class PenguinPacket
implements IMessage {
    public void handlePacket(EntityPlayer player) {
    }

    public boolean handleServerPacket(EntityPlayerMP player) {
        return false;
    }

    public void toBytes(ByteBuf to) {
    }

    public void fromBytes(ByteBuf from) {
    }

    public void handleQueuedClient(NetHandlerPlayClient handler) {
        this.handlePacket(MCClientHelper.getPlayer());
    }

    public void handleQueuedServer(NetHandlerPlayServer serverHandler) {
        if (!this.handleServerPacket(serverHandler.field_147369_b)) {
            this.handlePacket((EntityPlayer)serverHandler.field_147369_b);
        }
    }

    public void writeGzipString(ByteBuf buf, String string) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gzip = new GZIPOutputStream(baos);
            gzip.write(string.getBytes("UTF-8"));
            gzip.close();
            byte[] data = baos.toByteArray();
            buf.writeInt(data.length);
            buf.writeBytes(data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String readGzipString(ByteBuf buf) {
        try {
            int length = buf.readInt();
            byte[] data = buf.readBytes(length).array();
            GZIPInputStream gzip = new GZIPInputStream(new ByteArrayInputStream(data));
            BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)gzip, "UTF-8"));
            return CharStreams.toString((Readable)bf);
        }
        catch (Exception e) {
            return "";
        }
    }
}

