/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.network;

import io.netty.buffer.ByteBuf;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.network.penguin.PenguinPacket;
import net.minecraft.entity.player.EntityPlayer;

public class PacketSyncStats
extends PenguinPacket {
    private double stamina;
    private double fatigue;
    private double staminaMax;
    private double fatigueMin;

    public PacketSyncStats() {
    }

    public PacketSyncStats(double stamina, double fatigue, double staminaMax, double fatigueMin) {
        this.stamina = stamina;
        this.fatigue = fatigue;
        this.staminaMax = staminaMax;
        this.fatigueMin = fatigueMin;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.stamina);
        buf.writeDouble(this.fatigue);
        buf.writeDouble(this.staminaMax);
        buf.writeDouble(this.fatigueMin);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.stamina = buf.readDouble();
        this.fatigue = buf.readDouble();
        this.staminaMax = buf.readDouble();
        this.fatigueMin = buf.readDouble();
    }

    @Override
    public void handlePacket(EntityPlayer player) {
        HFTrackers.getClientPlayerTracker().getStats().setStats(this.stamina, this.fatigue, this.staminaMax, this.fatigueMin);
    }
}

