/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.network;

import io.netty.buffer.ByteBuf;
import joshie.harvest.api.relations.IRelatable;
import joshie.harvest.api.relations.IRelatableDataHandler;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.network.penguin.PenguinPacket;
import joshie.harvest.player.relationships.RelationshipHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PacketSyncRelationship
extends PenguinPacket {
    private IRelatableDataHandler handler;
    private IRelatable relatable;
    private int value;
    private boolean particles;

    public PacketSyncRelationship() {
    }

    public PacketSyncRelationship(IRelatable relatable, int value, boolean particles) {
        this.relatable = relatable;
        this.value = value;
        this.particles = particles;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.value);
        buf.writeBoolean(this.particles);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.relatable.getDataHandler().name());
        this.relatable.getDataHandler().toBytes(this.relatable, buf);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.value = buf.readInt();
        this.particles = buf.readBoolean();
        String handlerName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.handler = RelationshipHelper.getHandler((String)handlerName).copy();
        this.handler.fromBytes(buf);
    }

    @Override
    public void handlePacket(EntityPlayer player) {
        IRelatable relatable = this.handler.onMessage(this.particles);
        if (relatable != null) {
            HFTrackers.getClientPlayerTracker().getRelationships().setRelationship(relatable, this.value);
        }
    }
}

