/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import joshie.harvest.blocks.tiles.TileCooking;
import joshie.harvest.core.helpers.generic.MCClientHelper;
import joshie.harvest.core.network.AbstractPacketOrientation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PacketSyncCooking
extends AbstractPacketOrientation {
    private boolean isCooking;
    private boolean hasResult;
    private int iIngredient;
    private ArrayList<ItemStack> ingredients;
    private ItemStack result;

    public PacketSyncCooking() {
    }

    public PacketSyncCooking(int dim, BlockPos pos, EnumFacing dir, boolean isCooking, ArrayList<ItemStack> ingredients, ItemStack result) {
        super(dim, pos, dir);
        this.isCooking = isCooking;
        this.hasResult = result != null;
        this.iIngredient = ingredients.size();
        this.ingredients = ingredients;
        this.result = result;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeBoolean(this.isCooking);
        buf.writeBoolean(this.hasResult);
        buf.writeInt(this.iIngredient);
        if (this.iIngredient > 0) {
            for (int i = 0; i < this.iIngredient; ++i) {
                ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.ingredients.get(i));
            }
        }
        if (this.hasResult) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.result);
        }
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.isCooking = buf.readBoolean();
        this.hasResult = buf.readBoolean();
        this.iIngredient = buf.readInt();
        this.ingredients = new ArrayList(20);
        if (this.iIngredient > 0) {
            for (int i = 0; i < this.iIngredient; ++i) {
                this.ingredients.add(ByteBufUtils.readItemStack((ByteBuf)buf));
            }
        }
        if (this.hasResult) {
            this.result = ByteBufUtils.readItemStack((ByteBuf)buf);
        }
    }

    @Override
    public void handlePacket(EntityPlayer player) {
        super.handlePacket(player);
        TileEntity tile = MCClientHelper.getTile(this);
        if (tile instanceof TileCooking) {
            ((TileCooking)tile).setFromPacket(this.isCooking, this.ingredients, this.result);
        }
    }
}

