/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.network;

import io.netty.buffer.ByteBuf;
import joshie.harvest.api.calendar.ICalendarDate;
import joshie.harvest.api.calendar.Season;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.helpers.generic.MCClientHelper;
import joshie.harvest.core.network.penguin.PenguinPacket;
import net.minecraft.entity.player.EntityPlayer;

public class PacketSetCalendar
extends PenguinPacket {
    private int day;
    private Season season;
    private int year;

    public PacketSetCalendar() {
    }

    public PacketSetCalendar(ICalendarDate date) {
        this.day = date.getDay();
        this.season = date.getSeason();
        this.year = date.getYear();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.day);
        buf.writeByte(this.season.ordinal());
        buf.writeShort(this.year);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.day = buf.readByte();
        this.season = Season.values()[buf.readByte()];
        this.year = buf.readShort();
    }

    @Override
    public void handlePacket(EntityPlayer player) {
        ICalendarDate date = HFTrackers.getCalendar().getDate();
        Season previous = date.getSeason();
        date.setDay(this.day).setSeason(this.season).setYear(this.year);
        if (previous != this.season && previous != Season.SPRING && this.season != Season.SPRING) {
            MCClientHelper.refresh();
        }
    }
}

