/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Locale;
import java.util.Random;
import joshie.harvest.api.core.ISizedProvider;
import joshie.harvest.api.core.Size;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class SetSizeable
extends LootFunction {
    private final ISizedProvider provider;
    private final Object object;
    private final Size size;

    public SetSizeable(LootCondition[] conditionsIn, String sizeable, String object, String size) {
        super(conditionsIn);
        this.provider = (ISizedProvider)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(sizeable));
        this.object = this.provider.getObjectFromString(object);
        this.size = Size.valueOf(size.toUpperCase(Locale.ENGLISH));
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        if (stack.func_77973_b() instanceof ISizedProvider) {
            ISizedProvider provider = (ISizedProvider)stack.func_77973_b();
            return provider.getStackOfSize(this.object, this.size, 1);
        }
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<SetSizeable> {
        public Serializer() {
            super(new ResourceLocation("hf_set_sizeable"), SetSizeable.class);
        }

        public void serialize(JsonObject object, SetSizeable functionClazz, JsonSerializationContext serializationContext) {
            object.addProperty("item", ((Item)functionClazz.provider).getRegistryName().toString());
            object.addProperty("object", functionClazz.object.toString());
            object.addProperty("size", functionClazz.size.name());
        }

        public SetSizeable deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            return new SetSizeable(conditionsIn, object.get("item").getAsString(), object.get("object").getAsString(), object.get("size").getAsString());
        }
    }
}

