/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.lib;

import joshie.harvest.api.core.ISizeable;
import joshie.harvest.core.HFCore;
import joshie.harvest.core.handlers.SizeableRegistry;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class Sizeable
extends IForgeRegistryEntry.Impl<Sizeable> {
    private final String unlocalized;
    private final long small;
    private final long medium;
    private final long large;

    public Sizeable(String unlocalized, long small, long medium, long large) {
        this.unlocalized = unlocalized;
        this.small = small;
        this.medium = medium;
        this.large = large;
    }

    public boolean matches(ItemStack stack) {
        return stack != null && stack.func_77973_b() == HFCore.SIZEABLE && HFCore.SIZEABLE.getObjectFromStack(stack) == this;
    }

    public ItemStack getStack(ISizeable.Size size) {
        return this.getStackOfSize(size, 1);
    }

    public ItemStack getStackOfSize(ISizeable.Size size, int stackSize) {
        int sizeableID = SizeableRegistry.REGISTRY.getValues().indexOf((Object)this);
        int sizeID = size.ordinal();
        return new ItemStack((Item)HFCore.SIZEABLE, stackSize, sizeableID * 3 + sizeID);
    }

    public long getValue(ISizeable.Size size) {
        if (size == ISizeable.Size.LARGE) {
            return this.large;
        }
        if (size == ISizeable.Size.MEDIUM) {
            return this.medium;
        }
        return this.small;
    }

    public String getUnlocalizedName() {
        return this.unlocalized;
    }
}

