/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.item;

import java.util.List;
import java.util.Locale;
import joshie.harvest.api.core.IShippable;
import joshie.harvest.api.core.ISizeable;
import joshie.harvest.api.core.ISizedProvider;
import joshie.harvest.core.base.item.ItemHFFML;
import joshie.harvest.core.handlers.SizeableRegistry;
import joshie.harvest.core.lib.Sizeable;
import joshie.harvest.core.util.Text;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSizeable
extends ItemHFFML<ItemSizeable, Sizeable>
implements IShippable,
ISizedProvider {
    public ItemSizeable() {
        super(SizeableRegistry.REGISTRY);
    }

    @Override
    public Sizeable getNullValue() {
        return null;
    }

    @Override
    public Sizeable getObjectFromStack(ItemStack stack) {
        int real = (int)Math.floor(stack.func_77952_i() / 3);
        int id = Math.max(0, Math.min(SizeableRegistry.REGISTRY.getValues().size() - 1, real));
        return (Sizeable)((Object)SizeableRegistry.REGISTRY.getValues().get(id));
    }

    @Override
    public ISizeable.Size getSize(ItemStack stack) {
        return ISizeable.Size.values()[Math.min(2, stack.func_77952_i() % 3)];
    }

    @Override
    public int getSortValue(ItemStack stack) {
        return 11 + stack.func_77952_i() + SizeableRegistry.REGISTRY.getValues().indexOf((Object)this.getObjectFromStack(stack)) * 3;
    }

    @Override
    public long getSellValue(ItemStack stack) {
        return this.getObjectFromStack(stack).getValue(this.getSize(stack));
    }

    public String func_77667_c(ItemStack stack) {
        return this.getObjectFromStack(stack).getUnlocalizedName().toLowerCase(Locale.ENGLISH) + "_" + this.getSize(stack).toString().toLowerCase(Locale.ENGLISH);
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        ISizeable.Size sizeof = this.getSize(stack);
        String size = Text.translate("sizeable." + sizeof.name().toLowerCase(Locale.ENGLISH));
        String name = Text.translate("sizeable." + this.getObjectFromStack(stack).getUnlocalizedName());
        String format = Text.translate("sizeable.format");
        return String.format(format, size, name);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (Sizeable sizeable : SizeableRegistry.REGISTRY) {
            for (ISizeable.Size size : ISizeable.Size.values()) {
                list.add(sizeable.getStack(size));
            }
        }
    }
}

