/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.helpers.generic;

import java.util.List;
import joshie.harvest.core.helpers.generic.MCClientHelper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class StackHelper {
    public static void drawStack(ItemStack stack, int left, int top, float size) {
        GlStateManager.func_179118_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)size, (float)size, (float)size);
        GlStateManager.func_179140_f();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179145_e();
        GlStateManager.func_179091_B();
        RenderHelper.func_74520_c();
        Minecraft mc = MCClientHelper.getMinecraft();
        mc.func_175599_af().func_180450_b(stack, (int)((float)left / size), (int)((float)top / size));
        mc.func_175599_af().func_180453_a(mc.field_71466_p, stack, (int)((float)left / size), (int)((float)top / size), "");
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
        GlStateManager.func_179141_d();
    }

    public static ItemStack getStackFromString(String str) {
        if (str == null || str.equals("")) {
            return null;
        }
        return StackHelper.getStackFromArray(str.trim().split(" "));
    }

    public static String getStringFromObject(Object object) {
        if (object instanceof Item) {
            return StackHelper.getStringFromStack(new ItemStack((Item)object));
        }
        if (object instanceof Block) {
            return StackHelper.getStringFromStack(new ItemStack((Block)object));
        }
        if (object instanceof ItemStack) {
            return StackHelper.getStringFromStack((ItemStack)object);
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof List) {
            return StackHelper.getStringFromStack((ItemStack)((List)object).get(0));
        }
        return "";
    }

    public static String getStringFromStack(ItemStack stack) {
        String str = ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b())).toString().replace(" ", "%20");
        if (stack.func_77981_g() || stack.func_77984_f()) {
            str = str + " " + stack.func_77952_i();
        }
        if (stack.field_77994_a > 1) {
            str = str + " *" + stack.field_77994_a;
        }
        if (stack.func_77942_o()) {
            str = str + " " + stack.func_77978_p().toString();
        }
        return str;
    }

    public static NBTTagCompound getTag(String[] str, int pos) {
        String s = StackHelper.formatNBT(str, pos).func_150260_c();
        try {
            NBTTagCompound nbtbase = JsonToNBT.func_180713_a((String)s);
            if (!(nbtbase instanceof NBTTagCompound)) {
                return null;
            }
            return nbtbase;
        }
        catch (Exception nbtexception) {
            return null;
        }
    }

    public static boolean isMeta(String str) {
        return !StackHelper.isNBT(str) && !StackHelper.isAmount(str);
    }

    public static boolean isNBT(String str) {
        return str.startsWith("{");
    }

    public static boolean isAmount(String str) {
        return str.startsWith("*");
    }

    private static ItemStack getStackFromArray(String[] str) {
        Item item = StackHelper.getItemByText(str[0]);
        if (item == null) {
            return null;
        }
        int meta = 0;
        int amount = 1;
        ItemStack stack = new ItemStack(item, 1, meta);
        NBTTagCompound tag = null;
        for (int i = 1; i <= 3; ++i) {
            if (str.length <= i) continue;
            if (StackHelper.isMeta(str[i])) {
                meta = StackHelper.parseMeta(str[i]);
            }
            if (StackHelper.isAmount(str[i])) {
                amount = StackHelper.parseAmount(str[i]);
            }
            if (!StackHelper.isNBT(str[i])) continue;
            tag = StackHelper.getTag(str, i);
        }
        stack.func_77964_b(meta);
        stack.func_77982_d(tag);
        stack.field_77994_a = amount;
        return stack;
    }

    public static Item getItemByText(String str) {
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(str = str.replace("%20", " ")));
        if (item == null) {
            try {
                Item item1;
                item = item1 = Item.func_150899_d((int)Integer.parseInt(str));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return item;
    }

    private static ITextComponent formatNBT(String[] str, int start) {
        TextComponentString chatcomponenttext = new TextComponentString("");
        for (int j = start; j < str.length; ++j) {
            if (j > start) {
                chatcomponenttext.func_150258_a(" ");
            }
            TextComponentString object = new TextComponentString(str[j]);
            chatcomponenttext.func_150257_a((ITextComponent)object);
        }
        return chatcomponenttext;
    }

    private static int parseMeta(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException numberformatexception) {
            return 0;
        }
    }

    private static int parseAmount(String str) {
        try {
            return Integer.parseInt(str.substring(1, str.length()));
        }
        catch (NumberFormatException numberformatexception) {
            return 0;
        }
    }

    public static NBTTagCompound writeItemStackToNBT(NBTTagCompound tag, ItemStack stack) {
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        try {
            tag.func_74778_a("Name", ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b())).toString());
            tag.func_74768_a("Count", (int)((byte)stack.field_77994_a));
            tag.func_74768_a("Damage", (int)((short)stack.func_77952_i()));
            if (stack.func_77978_p() != null) {
                tag.func_74782_a("tag", (NBTBase)stack.func_77978_p());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tag;
    }

    public static ItemStack getItemStackFromNBT(NBTTagCompound tag) {
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(tag.func_74779_i("Name")));
        int count = tag.func_74762_e("Count");
        int damage = tag.func_74762_e("Damage");
        if (damage < 0) {
            damage = 0;
        }
        ItemStack stack = new ItemStack(item, count, damage);
        if (tag.func_150297_b("tag", 10)) {
            stack.func_77982_d(tag.func_74775_l("tag"));
        }
        return stack;
    }
}

