/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.helpers.generic;

import java.util.ArrayList;
import joshie.harvest.HarvestFestival;
import joshie.harvest.blocks.BlockCrop;
import joshie.harvest.core.util.base.BlockHFBaseEnum;
import joshie.harvest.core.util.base.ItemBlockHF;
import joshie.harvest.core.util.generic.Library;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;

public class RegistryHelper {
    public static Item registerItem(Item item, String name) {
        name = name.replace(".", "_");
        GameRegistry.register((IForgeRegistryEntry)item, (ResourceLocation)new ResourceLocation("harvestfestival", name));
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            if (item.func_77614_k()) {
                ArrayList subItems = new ArrayList();
                if (item.getCreativeTabs() != null && item.getCreativeTabs().length > 0) {
                    for (CreativeTabs tab : item.getCreativeTabs()) {
                        item.func_150895_a(item, tab, subItems);
                    }
                }
                for (ItemStack stack : subItems) {
                    String subItemName = item.func_77667_c(stack).replace("item.", "").replace(".", "_");
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)item.getDamage(stack), (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("harvestfestival", subItemName), "inventory"));
                    HarvestFestival.LOGGER.log(Level.INFO, "Sub item name " + subItemName);
                }
            } else {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("harvestfestival", name), "inventory"));
                HarvestFestival.LOGGER.log(Level.INFO, "Item Name " + name);
            }
        }
        if (Library.DEBUG_ON) {
            Library.log(Level.DEBUG, "Successfully registered the item " + item.getClass().getSimpleName() + " as " + "harvestfestival" + ":" + name);
        }
        return item;
    }

    public static Block registerBlock(Block block, String name) {
        ResourceLocation resource = new ResourceLocation("harvestfestival", name.replace(".", "_"));
        ItemBlockHF item = block instanceof BlockHFBaseEnum ? new ItemBlockHF((BlockHFBaseEnum)block) : new ItemBlock(block);
        GameRegistry.register((IForgeRegistryEntry)block, (ResourceLocation)resource);
        GameRegistry.register((IForgeRegistryEntry)item, (ResourceLocation)resource);
        if (!(block instanceof BlockCrop)) {
            HarvestFestival.proxy.setBlockModelResourceLocation(Item.func_150898_a((Block)block), name);
        }
        if (Library.DEBUG_ON) {
            Library.log(Level.DEBUG, "Successfully registered the block " + block.getClass().getSimpleName() + " as " + "harvestfestival" + ":" + name);
        }
        return block;
    }

    public static void registerTiles(String mod, Class<? extends TileEntity> ... tiles) {
        for (Class<? extends TileEntity> tile : tiles) {
            GameRegistry.registerTileEntity(tile, (String)(mod + ":" + tile.getSimpleName()));
        }
    }
}

