/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.helpers.generic;

import java.util.UUID;
import joshie.harvest.core.helpers.UUIDHelper;
import joshie.harvest.core.helpers.generic.MCServerHelper;
import joshie.harvest.npc.entity.EntityNPCBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class EntityHelper {
    public static EntityAnimal getAnimalFromUUID(int dimension, UUID uuid) {
        World world = MCServerHelper.getWorld(dimension);
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity entity = (Entity)world.field_72996_f.get(i);
            if (!(entity instanceof EntityAnimal) || !UUIDHelper.getEntityUUID(entity).equals(uuid)) continue;
            return (EntityAnimal)entity;
        }
        return null;
    }

    public static EntityNPCBuilder getBuilderFromUUID(int dimension, UUID uuid) {
        World world = MCServerHelper.getWorld(dimension);
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity entity = (Entity)world.field_72996_f.get(i);
            if (!(entity instanceof EntityNPCBuilder) || !UUIDHelper.getEntityUUID(entity).equals(uuid)) continue;
            return (EntityNPCBuilder)entity;
        }
        return null;
    }

    public static EntityPlayerMP getPlayerFromUUID(UUID uuid) {
        for (EntityPlayer player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            if (!UUIDHelper.getPlayerUUID(player).equals(uuid)) continue;
            return (EntityPlayerMP)player;
        }
        return null;
    }

    public static boolean isFakePlayer(EntityPlayer player) {
        return player instanceof FakePlayer || player.func_146103_bH().getName().equals("CoFH") || player.func_146103_bH().getName().startsWith("[Thaumcraft");
    }
}

