/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.helpers;

import joshie.harvest.animals.HFAnimals;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.animals.IAnimalTracked;
import joshie.harvest.api.core.ISizeable;
import joshie.harvest.core.lib.Sizeable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class SizeableHelper {
    public static ItemStack getMilk(EntityPlayer player, IAnimalTracked tracked) {
        return SizeableHelper.getSizeable(player, tracked, HFAnimals.MILK);
    }

    public static ItemStack getWool(EntityPlayer player, IAnimalTracked tracked) {
        return SizeableHelper.getSizeable(player, tracked, HFAnimals.WOOL);
    }

    public static ItemStack getSizeable(EntityPlayer player, IAnimalTracked tracked, Sizeable sizeable) {
        ISizeable.Size size = null;
        int relationship = HFApi.relationships.getRelationship(player, tracked.getUUID());
        for (ISizeable.Size s : ISizeable.Size.values()) {
            if (relationship < s.getRelationshipRequirement() / 5) continue;
            size = s;
        }
        return sizeable.getStackOfSize(size, tracked.getData().getProductsPerDay());
    }
}

