/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.helpers;

import java.util.HashMap;
import java.util.Map;
import joshie.harvest.api.calendar.CalendarDate;
import joshie.harvest.api.quests.Quest;
import joshie.harvest.core.util.adapter.CalendarAdapter;
import joshie.harvest.core.util.adapter.QuestAdapter;
import joshie.harvest.core.util.adapter.SerializeAdapter;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class SerializeHelper {
    public static final HashMap<Class, SerializeAdapter> ADAPTERS = new HashMap();

    public static <K, V> void writeMap(Map<K, V> map, String name, NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            NBTTagCompound nbt = new NBTTagCompound();
            ADAPTERS.get(entry.getKey().getClass()).writeToNBT(entry.getKey(), nbt);
            ADAPTERS.get(entry.getValue().getClass()).writeToNBT(entry.getValue(), nbt);
            list.func_74742_a((NBTBase)nbt);
        }
        tag.func_74782_a(name, (NBTBase)list);
    }

    public static <K, V> Map<K, V> readMap(Class<K> key, Class<V> value, String name, NBTTagCompound tag) {
        return SerializeHelper.readMap(HashMap.class, key, value, name, tag);
    }

    public static <K, V> Map<K, V> readMap(Class<? extends Map> clazz, Class<K> key, Class<V> value, String name, NBTTagCompound tag) {
        try {
            Map map = clazz.newInstance();
            NBTTagList list = tag.func_150295_c(name, 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound nbt = list.func_150305_b(i);
                map.put(ADAPTERS.get(key).readFromNBT(nbt), ADAPTERS.get(value).readFromNBT(nbt));
            }
            return map;
        }
        catch (IllegalAccessException | InstantiationException ex) {
            return null;
        }
    }

    static {
        ADAPTERS.put(Quest.class, new QuestAdapter());
        ADAPTERS.put(CalendarDate.class, new CalendarAdapter());
    }
}

