/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.helpers;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import joshie.harvest.api.animals.AnimalFoodType;
import joshie.harvest.api.cooking.ICookingComponent;
import joshie.harvest.api.cooking.IMealProvider;
import joshie.harvest.api.core.ISizedProvider;
import joshie.harvest.api.crops.ICropProvider;
import joshie.harvest.core.util.HFStack;
import joshie.harvest.core.util.MealStack;
import joshie.harvest.core.util.SafeStack;
import joshie.harvest.core.util.WildStack;
import net.minecraft.item.ItemStack;

public class SafeStackHelper {
    public static SafeStack getSafeStackType(ItemStack stack) {
        if (stack.func_77973_b() instanceof IMealProvider) {
            return new MealStack(stack);
        }
        if (stack.func_77973_b() instanceof ICropProvider || stack.func_77973_b() instanceof ISizedProvider) {
            return new HFStack(stack);
        }
        if (stack.func_77952_i() == Short.MAX_VALUE) {
            return new WildStack(stack);
        }
        return new SafeStack(stack);
    }

    public static Collection<ICookingComponent> getResult(ItemStack stack, Multimap<SafeStack, ICookingComponent> map) {
        Collection list = map.get((Object)new SafeStack(stack));
        if (list.size() < 1) {
            list = map.get((Object)new MealStack(stack));
        }
        if (list.size() < 1) {
            list = map.get((Object)new WildStack(stack));
        }
        if (list.size() < 1) {
            list = map.get((Object)new HFStack(stack));
        }
        return list;
    }

    public static Object getResult(ItemStack stack, HashMap<SafeStack, AnimalFoodType> map) {
        AnimalFoodType result = map.get(new SafeStack(stack));
        if (result == null) {
            result = map.get(new MealStack(stack));
        }
        if (result == null) {
            result = map.get(new WildStack(stack));
        }
        if (result == null) {
            result = map.get(new HFStack(stack));
        }
        return result;
    }
}

