/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.helpers;

import java.util.Locale;
import joshie.harvest.core.HFClientProxy;
import joshie.harvest.core.render.FakeEntityRenderer;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.npc.NPC;
import joshie.harvest.npc.render.NPCItemRenderer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RegistryHelper {
    public static void registerSounds(String ... sounds) {
        for (String sound : sounds) {
            ResourceLocation resource = new ResourceLocation("harvestfestival", sound);
            GameRegistry.register((IForgeRegistryEntry)new SoundEvent(resource), (ResourceLocation)resource);
        }
    }

    public static void registerTiles(Class<? extends TileEntity> ... tiles) {
        for (Class<? extends TileEntity> tile : tiles) {
            GameRegistry.registerTileEntity(tile, (String)("harvestfestival:" + tile.getSimpleName().replace("Tile", "").toLowerCase(Locale.ENGLISH)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerNPCRendererItem(NPC npc) {
        ItemStack stack = HFNPCs.SPAWNER_NPC.getStackFromObject(npc);
        ForgeHooksClient.registerTESRItemStack((Item)stack.func_77973_b(), (int)stack.func_77952_i(), NPCItemRenderer.NPCTile.class);
        ClientRegistry.bindTileEntitySpecialRenderer(NPCItemRenderer.NPCTile.class, (TileEntitySpecialRenderer)new NPCItemRenderer());
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerFluidBlockRendering(Block block, String name) {
        final ModelResourceLocation fluidLocation = new ModelResourceLocation("harvestfestival:fluids", name);
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return fluidLocation;
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerEntityRenderer(Item item, FakeEntityRenderer.EntityItemRenderer instance) {
        HFClientProxy.RENDER_MAP.put(item, instance);
        ClientRegistry.bindTileEntitySpecialRenderer(((Object)((Object)instance)).getClass(), (TileEntitySpecialRenderer)FakeEntityRenderer.INSTANCE);
    }
}

