/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.helpers;

import joshie.harvest.api.HFApi;
import joshie.harvest.api.cooking.ICookingComponent;
import joshie.harvest.api.cooking.IMealRecipe;
import joshie.harvest.cooking.Meal;
import joshie.harvest.cooking.Recipe;
import joshie.harvest.cooking.Utensil;

public class RecipeHelper {
    private static IMealRecipe addRecipe(String mealname, int stamina, int fatigue, int hunger, float saturation, int eatTimer, ICookingComponent ... ingredients) {
        return HFApi.COOKING.addRecipe(new Recipe(ingredients, new Meal(mealname, stamina, fatigue, hunger, saturation, eatTimer)));
    }

    private static IMealRecipe addRecipe(String mealname, int stamina, int fatigue, boolean drink, ICookingComponent ... ingredients) {
        int timer;
        int fill = ingredients.length / stamina * -fatigue + stamina / 7;
        float saturation = (float)((double)fill / (double)stamina * (double)ingredients.length);
        int n = timer = drink ? 8 : 4 + (ingredients.length + -fatigue) * 4;
        if (saturation <= 0.0f) {
            saturation = 0.01f;
        }
        if (fatigue != 0) {
            if (fill <= 0) {
                fill = 1;
            }
            fill = (int)((double)fill * 1.5);
            saturation *= 1.5f;
        }
        IMealRecipe ret = RecipeHelper.addRecipe(mealname, stamina, fatigue, fill, saturation, timer, ingredients);
        return drink ? ret.setIsDrink() : ret;
    }

    public static IMealRecipe addFryingPanRecipe(String mealname, int stamina, int fatigue, ICookingComponent ... ingredients) {
        return RecipeHelper.addRecipe(mealname, stamina, fatigue, false, ingredients).setRequiredTool(Utensil.FRYING_PAN);
    }

    public static IMealRecipe addMixerRecipe(String mealname, boolean isDrink, int stamina, int fatigue, ICookingComponent ... ingredients) {
        return RecipeHelper.addRecipe(mealname, stamina, fatigue, isDrink, ingredients).setRequiredTool(Utensil.MIXER);
    }

    public static IMealRecipe addMixerRecipe(String mealname, int stamina, int fatigue, ICookingComponent ... ingredients) {
        return RecipeHelper.addRecipe(mealname, stamina, fatigue, true, ingredients).setRequiredTool(Utensil.MIXER);
    }

    public static IMealRecipe addNoUtensilRecipe(String mealname, int stamina, int fatigue, ICookingComponent ... ingredients) {
        return RecipeHelper.addRecipe(mealname, stamina, fatigue, false, ingredients).setRequiredTool(Utensil.COUNTER);
    }

    public static IMealRecipe addPotRecipe(String mealname, boolean isDrink, int stamina, int fatigue, ICookingComponent ... ingredients) {
        return RecipeHelper.addRecipe(mealname, stamina, fatigue, isDrink, ingredients).setRequiredTool(Utensil.POT);
    }

    public static IMealRecipe addPotRecipe(String mealname, int stamina, int fatigue, ICookingComponent ... ingredients) {
        return RecipeHelper.addRecipe(mealname, stamina, fatigue, false, ingredients).setRequiredTool(Utensil.POT);
    }

    public static IMealRecipe addOvenRecipe(String mealname, int stamina, int fatigue, ICookingComponent ... ingredients) {
        return RecipeHelper.addRecipe(mealname, stamina, fatigue, false, ingredients).setRequiredTool(Utensil.OVEN);
    }
}

