/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.helpers;

import java.util.HashSet;
import joshie.harvest.api.HFApi;
import joshie.harvest.api.npc.INPC;
import joshie.harvest.api.quest.IQuest;
import joshie.harvest.api.relations.IRelatable;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.helpers.generic.ItemHelper;
import joshie.harvest.core.network.PacketHandler;
import joshie.harvest.core.network.quests.PacketQuestDecreaseHeld;
import joshie.harvest.core.util.generic.IdiotException;
import joshie.harvest.player.quests.QuestData;
import joshie.harvest.quests.Quest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;

public class QuestHelper {
    public static void completeQuest(EntityPlayer player, Quest quest) {
        HFTrackers.getPlayerTracker((EntityPlayer)player).getQuests().markCompleted(quest, true);
    }

    public static void takeHeldStack(EntityPlayer player, int amount) {
        if (player.field_70170_p.field_72995_K) {
            player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, amount);
            PacketHandler.sendToServer(new PacketQuestDecreaseHeld(amount));
        } else {
            player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, amount);
            ((EntityPlayerMP)player).playerNetServerHandler.func_147359_a((Packet)new SPacketSetSlot(-1, -1, player.func_184607_cu()));
        }
    }

    public static HashSet<IQuest> getCurrentQuest(EntityPlayer player) {
        return HFTrackers.getPlayerTracker((EntityPlayer)player).getQuests().getCurrent();
    }

    public static void rewardGold(EntityPlayer player, long amount) {
        if (player.field_70170_p.field_72995_K) {
            throw new IdiotException("Joshie shouldn't be rewarding anyone with gold client side");
        }
        HFTrackers.getServerPlayerTracker((EntityPlayer)player).getStats().addGold((EntityPlayerMP)player, amount);
    }

    public static void rewardRelations(EntityPlayer player, INPC npc, int amount) {
        HFApi.RELATIONS.adjustRelationship(player, (IRelatable)((Object)npc), amount);
    }

    public static void rewardItem(EntityPlayer player, ItemStack stack) {
        ItemHelper.addToPlayerInventory(player, stack);
    }

    public static void markCompleted(EntityPlayer player, IQuest quest) {
        HFTrackers.getPlayerTracker((EntityPlayer)player).getQuests().markCompleted(quest, false);
    }

    public static void markAvailable(EntityPlayer player, IQuest quest) {
        HFTrackers.getPlayerTracker((EntityPlayer)player).getQuests().setAvailable(quest);
    }

    public static void markAsCurrent(EntityPlayer player, IQuest quest) {
        HFTrackers.getPlayerTracker((EntityPlayer)player).getQuests().addAsCurrent(quest);
    }

    public static void setQuestStage(EntityPlayer player, IQuest quest, int stage) {
        QuestData stats = HFTrackers.getPlayerTracker((EntityPlayer)player).getQuests();
        int previous = stats.getAQuest(quest).getStage();
        stats.setStage(quest, stage);
        quest.onStageChanged(player, previous, stage);
    }

    public static void startQuest(EntityPlayer player, IQuest quest) {
        HFTrackers.getPlayerTracker((EntityPlayer)player).getQuests().startQuest(quest);
    }
}

