/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.helpers;

import java.util.UUID;
import joshie.harvest.api.npc.INPC;
import joshie.harvest.api.shops.IShop;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.npc.entity.EntityNPC;
import joshie.harvest.npc.entity.EntityNPCBuilder;
import joshie.harvest.npc.entity.EntityNPCShopkeeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class NPCHelper {
    public static BlockPos getHomeForEntity(EntityNPC entity) {
        UUID owner_uuid = entity.owning_player;
        INPC npc = entity.getNPC();
        if (npc.getHomeGroup() == null || npc.getHomeLocation() == null) {
            return null;
        }
        return HFTrackers.getPlayerTracker((UUID)owner_uuid).getTown().getCoordinatesFor(npc.getHomeGroup(), npc.getHomeLocation());
    }

    public static BlockPos getHomeForEntity(UUID owner, INPC npc) {
        if (npc.getHomeGroup() == null || npc.getHomeLocation() == null) {
            return null;
        }
        return HFTrackers.getPlayerTracker((UUID)owner).getTown().getCoordinatesFor(npc.getHomeGroup(), npc.getHomeLocation());
    }

    public static EntityNPC getEntityForNPC(UUID owning_player, World world, INPC npc) {
        if (npc.isBuilder()) {
            return new EntityNPCBuilder(owning_player, world, npc);
        }
        if (npc.getShop() != null) {
            return new EntityNPCShopkeeper(owning_player, world, npc);
        }
        return new EntityNPC(owning_player, world, npc);
    }

    public static boolean isShopOpen(INPC npc, World world, EntityPlayer player) {
        IShop shop = npc.getShop();
        return shop != null && shop.isOpen(world, player) && shop.getContents(player).size() > 0;
    }

    public static int getGuiIDForNPC(INPC npc, World world, EntityPlayer player, boolean isGifting) {
        if (NPCHelper.isShopOpen(npc, world, player)) {
            return 6;
        }
        return isGifting ? 2 : 0;
    }
}

