/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.helpers;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import joshie.harvest.core.base.tile.TileHarvest;
import joshie.harvest.core.helpers.MCServerHelper;
import joshie.harvest.core.util.holder.AbstractHolder;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class NBTHelper {
    public static void copyTileData(TileHarvest tile, World world, BlockPos pos, IBlockState state) {
        NBTTagCompound data = tile.func_189515_b(new NBTTagCompound());
        world.func_180501_a(pos, state, 2);
        TileHarvest tile2 = (TileHarvest)world.func_175625_s(pos);
        tile2.func_145839_a(data);
        MCServerHelper.markTileForUpdate(tile2);
    }

    private static <C extends Collection, H extends AbstractHolder> C readCollection(Class<C> c, Class<H> h, NBTTagList list) {
        try {
            Collection collection = (Collection)c.newInstance();
            for (int i = 0; i < list.func_74745_c(); ++i) {
                collection.add(h.getMethod("readFromNBT", NBTTagCompound.class).invoke(null, list.func_150305_b(i)));
            }
            return (C)collection;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                return (C)((Collection)c.newInstance());
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public static <H extends AbstractHolder> HashSet<H> readHashSet(Class<H> h, NBTTagList list) {
        return NBTHelper.readCollection(HashSet.class, h, list);
    }

    public static <C extends Collection<? extends AbstractHolder>> NBTTagList writeCollection(C set) {
        NBTTagList list = new NBTTagList();
        if (set != null) {
            for (AbstractHolder stack : set) {
                NBTTagCompound tag = new NBTTagCompound();
                try {
                    stack.writeToNBT(tag);
                    list.func_74742_a((NBTBase)tag);
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
        return list;
    }

    public static NBTTagList writePositionMap(TIntObjectMap<BlockPos> map) {
        NBTTagList list = new NBTTagList();
        for (int key : map.keys()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("Key", key);
            NBTHelper.writeBlockPos("Value", tag, (BlockPos)map.get(key));
            list.func_74742_a((NBTBase)tag);
        }
        return list;
    }

    public static NBTTagList writePositionCollection(TIntObjectMap<TIntObjectMap<BlockPos>> mapMap) {
        NBTTagList idList = new NBTTagList();
        for (int mapKey : mapMap.keys()) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("Key", mapKey);
            compound.func_74782_a("Value", (NBTBase)NBTHelper.writePositionMap((TIntObjectMap<BlockPos>)((TIntObjectMap)mapMap.get(mapKey))));
            idList.func_74742_a((NBTBase)compound);
        }
        return idList;
    }

    public static TIntObjectMap<BlockPos> readPositionMap(NBTTagList list) {
        TIntObjectHashMap ret = new TIntObjectHashMap();
        for (int j = 0; j < list.func_74745_c(); ++j) {
            NBTTagCompound tag = list.func_150305_b(j);
            try {
                int key = tag.func_74762_e("Key");
                BlockPos value = NBTHelper.readBlockPos("Value", tag);
                ret.put(key, (Object)value);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static TIntObjectMap<TIntObjectMap<BlockPos>> readPositionCollection(NBTTagList list) {
        TIntObjectHashMap mapMap = new TIntObjectHashMap();
        for (int j = 0; j < list.func_74745_c(); ++j) {
            NBTTagCompound tag = list.func_150305_b(j);
            try {
                int key = tag.func_74762_e("Key");
                TIntObjectMap<BlockPos> map = NBTHelper.readPositionMap(tag.func_150295_c("Value", 10));
                mapMap.put(key, map);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return mapMap;
    }

    public static BlockPos readBlockPos(String prefix, NBTTagCompound tag) {
        return tag.func_74764_b(prefix + "X") ? new BlockPos(tag.func_74762_e(prefix + "X"), tag.func_74762_e(prefix + "Y"), tag.func_74762_e(prefix + "Z")) : BlockPos.field_177992_a;
    }

    public static void writeBlockPos(String prefix, NBTTagCompound tag, BlockPos pos) {
        if (pos != null) {
            tag.func_74768_a(prefix + "X", pos.func_177958_n());
            tag.func_74768_a(prefix + "Y", pos.func_177956_o());
            tag.func_74768_a(prefix + "Z", pos.func_177952_p());
        }
    }

    public static UUID readUUID(String prefix, NBTTagCompound nbt) {
        String key = prefix + "UUID";
        if (nbt.func_74764_b(key)) {
            return UUID.fromString(nbt.func_74779_i(key));
        }
        return UUID.randomUUID();
    }

    public static void writeUUID(String prefix, NBTTagCompound nbt, UUID uuid) {
        if (uuid != null) {
            nbt.func_74778_a(prefix + "UUID", uuid.toString());
        }
    }

    public static Set<ResourceLocation> readResourceSet(NBTTagCompound nbt, String name) {
        NBTTagList list = nbt.func_150295_c(name, 8);
        HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            set.add(new ResourceLocation(list.func_150307_f(i)));
        }
        return set;
    }

    public static NBTTagList writeResourceSet(Set<ResourceLocation> resources) {
        NBTTagList list = new NBTTagList();
        for (ResourceLocation resource : resources) {
            list.func_74742_a((NBTBase)new NBTTagString(resource.toString()));
        }
        return list;
    }

    public static Set<UUID> readUUIDSet(NBTTagCompound nbt, String name) {
        NBTTagList list = nbt.func_150295_c(name, 8);
        HashSet<UUID> set = new HashSet<UUID>();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            set.add(UUID.fromString(list.func_150307_f(i)));
        }
        return set;
    }

    public static NBTTagList writeUUIDSet(Set<UUID> resources) {
        NBTTagList list = new NBTTagList();
        for (UUID uuid : resources) {
            list.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
        }
        return list;
    }

    public static ItemStack readItemStack(NBTTagCompound nbt) {
        Item item = Item.func_111206_d((String)nbt.func_74779_i("id"));
        if (item == null) {
            return null;
        }
        ItemStack stack = new ItemStack(item);
        stack.field_77994_a = nbt.func_74762_e("Count");
        short damage = nbt.func_74765_d("Damage");
        if (damage < 0) {
            damage = 0;
        }
        stack.func_77964_b((int)damage);
        if (nbt.func_150297_b("tag", 10)) {
            stack.func_77982_d(nbt.func_74775_l("tag"));
            stack.func_77973_b().func_179215_a(stack.func_77978_p());
        } else {
            stack.func_77982_d(null);
        }
        return stack;
    }

    public static NBTTagCompound writeItemStack(ItemStack stack, NBTTagCompound nbt) {
        ResourceLocation resourcelocation = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b());
        nbt.func_74778_a("id", resourcelocation == null ? "minecraft:air" : resourcelocation.toString());
        nbt.func_74768_a("Count", stack.field_77994_a);
        nbt.func_74777_a("Damage", (short)stack.func_77952_i());
        if (stack.func_77978_p() != null) {
            nbt.func_74782_a("tag", (NBTBase)stack.func_77978_p());
        }
        return nbt;
    }
}

