/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.helpers;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.oredict.OreDictionary;

public class InventoryHelper {
    public static final Matcher<String> ORE_DICTIONARY = new Matcher<String>(){

        @Override
        public boolean matches(ItemStack stack, String string) {
            return InventoryHelper.isOreName(stack, string);
        }
    };
    public static final Matcher<ItemStack> ITEM_STACK = new Matcher<ItemStack>(){

        @Override
        public boolean matches(ItemStack stack, ItemStack stack2) {
            return stack.func_77969_a(stack2);
        }
    };
    public static final Matcher<Item> ITEM = new Matcher<Item>(){

        @Override
        public boolean matches(ItemStack stack, Item item) {
            return stack.func_77973_b() == item;
        }
    };
    public static final Matcher<SearchType> SPECIAL = new Matcher<SearchType>(){

        @Override
        public boolean matches(ItemStack stack, SearchType type) {
            if (type.equals((Object)SearchType.FLOWER)) {
                if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150328_O) || stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150327_N)) {
                    return true;
                }
                for (String name : InventoryHelper.getOreNames(stack)) {
                    if (!name.startsWith("flower")) continue;
                    return true;
                }
                return false;
            }
            if (type.equals((Object)SearchType.HOE)) {
                return stack.func_77973_b() instanceof ItemHoe;
            }
            if (type.equals((Object)SearchType.BUCKET)) {
                return stack.func_77973_b() instanceof ItemBucket;
            }
            if (type.equals((Object)SearchType.SHEARS)) {
                return stack.func_77973_b() instanceof ItemShears;
            }
            return false;
        }
    };

    private static <T> void takeItems(EntityPlayer player, T taking, int amount, Matcher<T> matcher) {
        int toTake = amount;
        ItemStack offhand = player.field_71071_by.field_184439_c[0];
        if (offhand != null && matcher.matches(offhand, taking)) {
            ItemStack taken = offhand.func_77979_a(toTake);
            toTake -= taken.field_77994_a;
            if (offhand.field_77994_a <= 0) {
                player.field_71071_by.field_184439_c[0] = null;
            }
            if (toTake <= 0) {
                return;
            }
        }
        for (int i = 0; i < player.field_71071_by.field_70462_a.length && toTake > 0; ++i) {
            ItemStack stack = player.field_71071_by.field_70462_a[i];
            if (stack == null || !matcher.matches(stack, taking)) continue;
            ItemStack taken = stack.func_77979_a(toTake);
            toTake -= taken.field_77994_a;
            if (stack.field_77994_a <= 0) {
                player.field_71071_by.field_70462_a[i] = null;
            }
            if (toTake > 0) continue;
            return;
        }
    }

    public static <S> boolean hasInInventory(EntityPlayer player, Matcher matcher, S search, int ... amount) {
        int count = amount == null || amount.length == 0 ? 1 : amount[0];
        return InventoryHelper.getCount(player, search, matcher) >= count;
    }

    public static <S> boolean takeItemsInInventory(EntityPlayer player, Matcher matcher, S search, int ... amount) {
        int count;
        int n = count = amount == null || amount.length == 0 ? 1 : amount[0];
        if (InventoryHelper.hasInInventory(player, matcher, search, count)) {
            InventoryHelper.takeItems(player, search, count, matcher);
            return true;
        }
        return false;
    }

    private static <S> int getStackSizeOfHand(EntityPlayer player, Matcher<S> matcher, S search, EnumHand hand) {
        ItemStack held = player.func_184586_b(hand);
        if (held != null && matcher.matches(held, search)) {
            return held.field_77994_a;
        }
        return 0;
    }

    public static <S> EnumHand getHandItemIsIn(EntityPlayer player, Matcher<S> matcher, S search, int ... amount) {
        int count = amount == null || amount.length == 0 ? 1 : amount[0];
        for (EnumHand hand : EnumHand.values()) {
            if (InventoryHelper.getStackSizeOfHand(player, matcher, search, hand) == 0 || InventoryHelper.getCount(player, search, matcher) < count) continue;
            return hand;
        }
        return null;
    }

    private static int reduceHeld(EntityPlayer player, EnumHand hand, int amount) {
        ItemStack held = player.func_184586_b(hand);
        if (held.field_77994_a <= amount) {
            int ret = held.field_77994_a;
            player.func_184611_a(hand, null);
            return ret;
        }
        held.field_77994_a -= amount;
        return amount;
    }

    public static <S> EnumHand takeItemsIfHeld(EntityPlayer player, Matcher matcher, S search, int ... amount) {
        int count = amount == null || amount.length == 0 ? 1 : amount[0];
        EnumHand ret = InventoryHelper.getHandItemIsIn(player, matcher, search, count);
        if (ret != null) {
            if ((count -= InventoryHelper.reduceHeld(player, ret, count)) > 0) {
                InventoryHelper.takeItems(player, search, count, matcher);
            }
            return ret;
        }
        return null;
    }

    private static <T> int getCount(EntityPlayer player, T taking, Matcher<T> matcher) {
        int count = 0;
        for (ItemStack item : player.field_71071_by.field_70462_a) {
            if (item == null || !matcher.matches(item, taking)) continue;
            count += item.field_77994_a;
        }
        ItemStack offhand = player.field_71071_by.field_184439_c[0];
        if (offhand != null && matcher.matches(offhand, taking)) {
            count += offhand.field_77994_a;
        }
        return count;
    }

    public static boolean isOreName(ItemStack stack, String ore) {
        int[] ids;
        for (int i : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
            String name = OreDictionary.getOreName((int)i);
            if (!name.equals(ore)) continue;
            return true;
        }
        return false;
    }

    public static String[] getOreNames(ItemStack stack) {
        int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
        String[] names = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            names[i] = OreDictionary.getOreName((int)ids[i]);
        }
        return names;
    }

    public static abstract class Matcher<T> {
        public abstract boolean matches(@Nonnull ItemStack var1, T var2);
    }

    public static enum SearchType {
        FLOWER,
        HOE,
        BUCKET,
        SHEARS;

    }
}

