/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.helpers;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import joshie.harvest.core.util.HFTeleporter;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateHealth;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class EntityHelper {
    public static <E extends Entity> E getAnimalFromUUID(World world, UUID uuid) {
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity entity = (Entity)world.field_72996_f.get(i);
            if (!(entity instanceof EntityAnimal) || !EntityHelper.getEntityUUID(entity).equals(uuid)) continue;
            return (E)entity;
        }
        return null;
    }

    public static EntityPlayerMP getPlayerFromUUID(UUID uuid) {
        for (EntityPlayer player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            if (!EntityHelper.getPlayerUUID(player).equals(uuid)) continue;
            return (EntityPlayerMP)player;
        }
        return null;
    }

    public static boolean isFakePlayer(EntityPlayer player) {
        return player instanceof FakePlayer || player.func_146103_bH().getName().equals("CoFH") || player.func_146103_bH().getName().startsWith("[Thaumcraft");
    }

    public static <T extends Entity> List<T> getEntities(Class<? extends T> t, World world, BlockPos pos, double size, double ySize) {
        return world.func_72872_a(t, new AxisAlignedBB((double)((float)pos.func_177958_n() - 0.5f), (double)((float)pos.func_177956_o() - 0.5f), (double)((float)pos.func_177952_p() - 0.5f), (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f)).func_72314_b(size, ySize, size));
    }

    public static boolean teleport(Entity entity, int dimension, BlockPos spawn) {
        WorldServer newWorld;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        WorldServer oldWorld = server.func_71218_a(entity.func_130014_f_().field_73011_w.getDimension());
        if (oldWorld != (newWorld = server.func_71218_a(dimension))) {
            if (entity instanceof EntityPlayer) {
                EntityPlayerMP player = (EntityPlayerMP)entity;
                if (!player.field_70170_p.field_72995_K) {
                    ReflectionHelper.setPrivateValue(EntityPlayerMP.class, (Object)player, (Object)true, (String[])new String[]{"invulnerableDimensionChange", "field_184851_cj"});
                    newWorld.func_73046_m().func_184103_al().transferPlayerToDimension(player, dimension, (Teleporter)new HFTeleporter(newWorld, spawn));
                    player.func_70634_a((double)spawn.func_177958_n(), (double)spawn.func_177956_o(), (double)spawn.func_177952_p());
                    player.field_70170_p.func_72866_a((Entity)player, false);
                    player.field_71135_a.func_147359_a((Packet)new SPacketUpdateHealth(player.func_110143_aJ(), player.func_71024_bL().func_75116_a(), player.func_71024_bL().func_75115_e()));
                }
            } else if (!entity.field_70170_p.field_72995_K) {
                NBTTagCompound tag = new NBTTagCompound();
                entity.func_70039_c(tag);
                entity.func_70106_y();
                Entity teleportedEntity = EntityList.func_75615_a((NBTTagCompound)tag, (World)newWorld);
                if (teleportedEntity != null) {
                    teleportedEntity.func_70634_a((double)spawn.func_177958_n(), (double)spawn.func_177956_o(), (double)spawn.func_177952_p());
                    teleportedEntity.field_98038_p = true;
                    newWorld.func_72838_d(teleportedEntity);
                    teleportedEntity.func_70029_a((World)newWorld);
                    teleportedEntity.field_71088_bW = teleportedEntity instanceof EntityPlayer ? 150 : 20;
                }
                oldWorld.func_82742_i();
                newWorld.func_82742_i();
            }
        }
        if (entity instanceof EntityPlayerMP) {
            ReflectionHelper.setPrivateValue(EntityPlayerMP.class, (Object)((EntityPlayerMP)entity), (Object)true, (String[])new String[]{"invulnerableDimensionChange", "field_184851_cj"});
            entity.func_70634_a((double)spawn.func_177958_n() + 0.5, (double)spawn.func_177956_o() + 0.1, (double)spawn.func_177952_p() + 0.5);
        }
        entity.field_71088_bW = entity instanceof EntityLiving ? 150 : 20;
        return true;
    }

    public static EnumFacing getFacingFromEntity(EntityLivingBase entity) {
        int facing = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        EnumFacing dir = EnumFacing.NORTH;
        if (facing == 0) {
            return EnumFacing.NORTH;
        }
        if (facing == 1) {
            return EnumFacing.EAST;
        }
        if (facing == 2) {
            return EnumFacing.SOUTH;
        }
        if (facing == 3) {
            return EnumFacing.WEST;
        }
        return dir;
    }

    public static UUID getLastKnownUUID(EntityPlayer player) {
        String name = player.func_146103_bH().getName();
        for (Map.Entry entry : UsernameCache.getMap().entrySet()) {
            if (!((String)entry.getValue()).equals(name)) continue;
            return (UUID)entry.getKey();
        }
        return EntityHelper.getPlayerUUID(player);
    }

    public static UUID getEntityUUID(Entity entity) {
        return entity.getPersistentID();
    }

    public static UUID getPlayerUUID(EntityPlayer player) {
        return EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH());
    }

    public static EntityPlayer getPlayerFromSource(DamageSource source) {
        if (source.func_76346_g() instanceof EntityPlayer) {
            return (EntityPlayer)source.func_76346_g();
        }
        if (source.func_76364_f() instanceof EntityPlayer) {
            return (EntityPlayer)source.func_76364_f();
        }
        return null;
    }

    public static boolean isSpawnable(World world, BlockPos pos) {
        return world.func_175623_d(pos);
    }
}

