/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.helpers;

import joshie.harvest.api.crops.ICropData;
import joshie.harvest.api.crops.IStateHandler;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.helpers.generic.ItemHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class CropHelper {
    public static IBlockState getBlockState(World world, BlockPos pos, IStateHandler.PlantSection section, boolean withered) {
        ICropData data = HFTrackers.getCropTracker().getCropDataForLocation(world, pos);
        return data.getCrop().getStateHandler().getState(section, data.getStage(), withered);
    }

    public static AxisAlignedBB getCropBoundingBox(World world, BlockPos pos, IStateHandler.PlantSection section, boolean withered) {
        ICropData data = HFTrackers.getCropTracker().getCropDataForLocation(world, pos);
        return data.getCrop().getStateHandler().getBoundingBox(section, data.getStage(), withered);
    }

    public static boolean hydrate(World world, BlockPos pos) {
        boolean ret;
        IBlockState state = world.func_180495_p(pos);
        int meta = (Integer)state.func_177229_b((IProperty)BlockFarmland.field_176531_a);
        boolean bl = ret = meta != 7 && world.func_180501_a(pos, state.func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(7)), 2);
        if (ret) {
            HFTrackers.getCropTracker().hydrate(world, pos.func_177984_a(), state);
        }
        return ret;
    }

    public static boolean dehydrate(World world, BlockPos pos, IBlockState state) {
        Block crop = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        Block farmland = state.func_177230_c();
        if (!(farmland instanceof BlockFarmland)) {
            return true;
        }
        int meta = (Integer)state.func_177229_b((IProperty)BlockFarmland.field_176531_a);
        if (crop instanceof IPlantable && farmland.canSustainPlant(state, (IBlockAccess)world, pos, EnumFacing.UP, (IPlantable)crop)) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(0)), 2);
            return true;
        }
        if (meta == 7) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(0)), 2);
            return true;
        }
        return false;
    }

    public static boolean isHydrated(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() instanceof BlockFarmland && (Integer)state.func_177229_b((IProperty)BlockFarmland.field_176531_a) == 7;
    }

    public static boolean harvestCrop(EntityPlayer player, World world, BlockPos pos) {
        ItemStack stack = HFTrackers.getCropTracker().harvest(player, world, pos);
        if (!world.field_72995_K && stack != null) {
            ItemHelper.dropBlockAsItem(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), stack);
        }
        return stack != null;
    }
}

