/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.helpers;

import joshie.harvest.api.calendar.ICalendarDate;
import joshie.harvest.core.config.Calendar;
import net.minecraft.world.World;

public class CalendarHelper {
    public static int getTotalDays(ICalendarDate date) {
        int current_days = date.getDay();
        int season_days = Calendar.DAYS_PER_SEASON * date.getSeason().ordinal();
        int year_days = (date.getYear() - 1) * (Calendar.DAYS_PER_SEASON * 4);
        return current_days + season_days + year_days;
    }

    public static int getYearsPassed(ICalendarDate birthday, ICalendarDate date) {
        int current_total_days = CalendarHelper.getTotalDays(date);
        int birthday_total_days = CalendarHelper.getTotalDays(birthday);
        int one_year = Calendar.DAYS_PER_SEASON * 4;
        int years_passed = current_total_days / one_year;
        int birthday_years = birthday_total_days / one_year;
        return years_passed - birthday_years;
    }

    public static long getTime(World world) {
        return (world.func_72820_D() + 6000L) % Calendar.TICKS_PER_DAY;
    }

    public static int getScaledTime(int time) {
        return (int)((double)time / 24000.0 * (double)Calendar.TICKS_PER_DAY);
    }
}

