/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.handlers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import joshie.harvest.api.ticking.IDailyTickable;
import joshie.harvest.api.ticking.IDailyTickableBlock;
import joshie.harvest.core.HFTracker;
import joshie.harvest.core.handlers.HFTrackers;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class TickDailyServer
extends HFTracker {
    private static final Set<Runnable> queue = new HashSet<Runnable>();
    private final Set<IDailyTickable> priority = new HashSet<IDailyTickable>();
    private final Set<IDailyTickable> tickables = new HashSet<IDailyTickable>();
    private final HashMap<BlockPos, IDailyTickableBlock> blockTicks = new HashMap();
    private long rateLimit;

    public static void addToQueue(Runnable runnable) {
        queue.add(runnable);
    }

    public static void processQueue() {
        HashSet<Runnable> toProcess = new HashSet<Runnable>(queue);
        queue.clear();
        toProcess.forEach(Runnable::run);
    }

    public void newDay(IDailyTickable.Phase phase) {
        if (phase == IDailyTickable.Phase.MINE) {
            if (System.currentTimeMillis() - this.rateLimit < 10000L) {
                return;
            }
            this.rateLimit = System.currentTimeMillis();
        }
        this.processTickables(this.priority, phase);
        if (phase == IDailyTickable.Phase.PRE || phase == IDailyTickable.Phase.MINE) {
            Iterator<Map.Entry<BlockPos, IDailyTickableBlock>> position = this.blockTicks.entrySet().iterator();
            while (position.hasNext()) {
                Map.Entry<BlockPos, IDailyTickableBlock> entry = position.next();
                BlockPos pos = entry.getKey();
                if (pos == null) {
                    position.remove();
                    continue;
                }
                if (!this.getWorld().func_175667_e(pos)) continue;
                IBlockState state = this.getWorld().func_180495_p(pos);
                IDailyTickableBlock tickable = entry.getValue();
                if (tickable != null) {
                    if (phase != IDailyTickable.Phase.PRE && (phase != IDailyTickable.Phase.MINE || !tickable.isMiningWorld()) || tickable.newDay(this.getWorld(), pos, state)) continue;
                    position.remove();
                    continue;
                }
                position.remove();
            }
        }
        this.processTickables(this.tickables, phase);
    }

    public void processTickables(Set<IDailyTickable> tickables, IDailyTickable.Phase phase) {
        Iterator<IDailyTickable> ticking = tickables.iterator();
        while (ticking.hasNext()) {
            IDailyTickable tickable = ticking.next();
            if (tickable == null || ((TileEntity)tickable).func_145837_r()) {
                ticking.remove();
                continue;
            }
            tickable.newDay(phase);
        }
    }

    public void add(BlockPos pos, IDailyTickableBlock daily) {
        this.blockTicks.put(pos, daily);
        HFTrackers.markDirty(this.getDimension());
    }

    public void remove(BlockPos pos) {
        this.blockTicks.remove(pos);
        HFTrackers.markDirty(this.getDimension());
    }

    public void add(IDailyTickable tickable) {
        if (tickable.isPriority()) {
            this.priority.add(tickable);
        } else {
            this.tickables.add(tickable);
        }
    }

    public void remove(IDailyTickable tickable) {
        if (tickable.isPriority()) {
            this.priority.remove(tickable);
        } else {
            this.tickables.remove(tickable);
        }
    }
}

