/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.handlers;

import java.util.List;
import joshie.harvest.core.HFCore;
import joshie.harvest.core.util.HFEvents;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@HFEvents
public class SleepHandler {
    public static boolean register() {
        return HFCore.SLEEP_ANYTIME;
    }

    @SubscribeEvent
    public void onPlayerSleep(PlayerSleepInBedEvent event) {
        event.setResult(this.trySleep(event.getEntityPlayer(), event.getPos()));
    }

    private EntityPlayer.SleepResult trySleep(EntityPlayer player, BlockPos bedLocation) {
        if (!player.field_70170_p.field_72995_K) {
            if (player.func_70608_bn() || !player.func_70089_S()) {
                return EntityPlayer.SleepResult.OTHER_PROBLEM;
            }
            if (!player.field_70170_p.field_73011_w.func_76569_d()) {
                return EntityPlayer.SleepResult.NOT_POSSIBLE_HERE;
            }
            if (Math.abs(player.field_70165_t - (double)bedLocation.func_177958_n()) > 3.0 || Math.abs(player.field_70163_u - (double)bedLocation.func_177956_o()) > 2.0 || Math.abs(player.field_70161_v - (double)bedLocation.func_177952_p()) > 3.0) {
                return EntityPlayer.SleepResult.TOO_FAR_AWAY;
            }
            List list = player.field_70170_p.func_72872_a(EntityMob.class, new AxisAlignedBB((double)bedLocation.func_177958_n() - 8.0, (double)bedLocation.func_177956_o() - 5.0, (double)bedLocation.func_177952_p() - 8.0, (double)bedLocation.func_177958_n() + 8.0, (double)bedLocation.func_177956_o() + 5.0, (double)bedLocation.func_177952_p() + 8.0));
            if (!list.isEmpty()) {
                return EntityPlayer.SleepResult.NOT_SAFE;
            }
        }
        if (player.func_184218_aH()) {
            player.func_184210_p();
        }
        this.setSize(player, 0.2f, 0.2f);
        IBlockState state = null;
        if (player.field_70170_p.func_175667_e(bedLocation)) {
            state = player.field_70170_p.func_180495_p(bedLocation);
        }
        if (state != null && state.func_177230_c().isBed(state, (IBlockAccess)player.field_70170_p, bedLocation, (Entity)player)) {
            EnumFacing enumfacing = state.func_177230_c().getBedDirection(state, (IBlockAccess)player.field_70170_p, bedLocation);
            float f = 0.5f;
            float f1 = 0.5f;
            switch (enumfacing) {
                case SOUTH: {
                    f1 = 0.9f;
                    break;
                }
                case NORTH: {
                    f1 = 0.1f;
                    break;
                }
                case WEST: {
                    f = 0.1f;
                    break;
                }
                case EAST: {
                    f = 0.9f;
                }
            }
            player.func_175139_a(enumfacing);
            player.func_70107_b((double)((float)bedLocation.func_177958_n() + f), (double)((float)bedLocation.func_177956_o() + 0.6875f), (double)((float)bedLocation.func_177952_p() + f1));
        } else {
            player.func_70107_b((double)((float)bedLocation.func_177958_n() + 0.5f), (double)((float)bedLocation.func_177956_o() + 0.6875f), (double)((float)bedLocation.func_177952_p() + 0.5f));
        }
        player.field_71083_bS = true;
        player.field_71076_b = 0;
        player.field_71081_bT = bedLocation;
        player.field_70159_w = 0.0;
        player.field_70181_x = 0.0;
        player.field_70179_y = 0.0;
        if (!player.field_70170_p.field_72995_K) {
            player.field_70170_p.func_72854_c();
        }
        return EntityPlayer.SleepResult.OK;
    }

    private void setSize(EntityPlayer player, float width, float height) {
        if (width != player.field_70130_N || height != player.field_70131_O) {
            float f = player.field_70130_N;
            player.field_70130_N = width;
            player.field_70131_O = height;
            AxisAlignedBB axisalignedbb = player.func_174813_aQ();
            player.func_174826_a(new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72340_a + (double)player.field_70130_N, axisalignedbb.field_72338_b + (double)player.field_70131_O, axisalignedbb.field_72339_c + (double)player.field_70130_N));
            if (player.field_70130_N > f && !player.field_70148_d && !player.field_70170_p.field_72995_K) {
                player.func_70091_d((double)(f - player.field_70130_N), 0.0, (double)(f - player.field_70130_N));
            }
        }
    }
}

