/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.handlers;

import java.util.HashMap;
import joshie.harvest.api.core.ISizeable;
import joshie.harvest.api.core.ISizeableRegistry;
import joshie.harvest.api.core.ISizedProvider;
import joshie.harvest.core.lib.Sizeable;
import joshie.harvest.core.util.HFApiImplementation;
import joshie.harvest.core.util.holder.ItemStackHolder;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.common.registry.RegistryBuilder;

@HFApiImplementation
public class SizeableRegistry
implements ISizeableRegistry {
    public static final IForgeRegistry<Sizeable> REGISTRY = new RegistryBuilder().setName(new ResourceLocation("harvestfestival", "sizeables")).setType(Sizeable.class).setIDRange(0, 32000).create();
    public static final SizeableRegistry INSTANCE = new SizeableRegistry();
    private final HashMap<ItemStackHolder, ISizeable.Size> providers = new HashMap();

    private SizeableRegistry() {
    }

    public Sizeable registerSizeable(String name, long sellSmall, long sellMedium, long sellLarge) {
        Sizeable meta = new Sizeable(name, sellSmall, sellMedium, sellLarge);
        meta.setRegistryName(new ResourceLocation("harvestfestival", name));
        REGISTRY.register((IForgeRegistryEntry)meta);
        return meta;
    }

    @Override
    public void registerStackAsSize(ItemStack stack, ISizeable.Size size) {
        this.providers.put(ItemStackHolder.of(stack.func_77973_b(), stack.func_77952_i()), size);
    }

    @Override
    public ISizeable.Size getSize(ItemStack stack) {
        if (stack.func_77973_b() instanceof ISizedProvider) {
            return ((ISizedProvider)stack.func_77973_b()).getSize(stack);
        }
        return this.providers.get(ItemStackHolder.of(stack));
    }
}

