/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.handlers;

import joshie.harvest.api.HFApi;
import joshie.harvest.api.core.IShippable;
import joshie.harvest.api.core.IShippingRegistry;
import joshie.harvest.api.core.Ore;
import joshie.harvest.api.crops.Crop;
import joshie.harvest.core.util.HFApiImplementation;
import joshie.harvest.core.util.holder.HolderRegistry;
import net.minecraft.item.ItemStack;

@HFApiImplementation
public class ShippingRegistry
implements IShippingRegistry {
    public static final ShippingRegistry INSTANCE = new ShippingRegistry();
    private final HolderRegistry<Long> registry = new HolderRegistry();

    private ShippingRegistry() {
    }

    @Override
    public void registerSellable(ItemStack stack, long value) {
        this.registry.register(stack, value);
    }

    @Override
    public void registerSellable(Ore ore, long value) {
        this.registry.register(ore, value);
    }

    @Override
    public long getSellValue(ItemStack stack) {
        if (stack.func_77973_b() instanceof IShippable) {
            return ((IShippable)stack.func_77973_b()).getSellValue(stack);
        }
        Crop crop = HFApi.crops.getCropFromStack(stack);
        if (crop != null) {
            return crop.getSellValue(stack);
        }
        Long value = this.registry.getValueOf(stack);
        return value == null ? 0L : value;
    }
}

