/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.handlers;

import joshie.harvest.animals.HFAnimals;
import joshie.harvest.animals.tracker.AnimalTrackerServer;
import joshie.harvest.api.calendar.CalendarDate;
import joshie.harvest.api.ticking.IDailyTickable;
import joshie.harvest.calendar.CalendarServer;
import joshie.harvest.calendar.HFCalendar;
import joshie.harvest.core.HFTrackers;
import joshie.harvest.core.handlers.DailyTickHandler;
import joshie.harvest.core.handlers.OfflineTickHandler;
import joshie.harvest.core.util.annotations.HFEvents;
import joshie.harvest.player.PlayerTrackerServer;
import joshie.harvest.town.tracker.TownTrackerServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@HFEvents
public class NewDayHandler {
    public static void newDay(World world) {
        DailyTickHandler tickables = HFTrackers.getTickables(world);
        tickables.processPhase(IDailyTickable.Phase.PRIORITY);
        tickables.processBlocks();
        tickables.processPhase(IDailyTickable.Phase.PRE);
        ((AnimalTrackerServer)HFTrackers.getAnimalTracker(world)).newDay();
        ((TownTrackerServer)HFTrackers.getTownTracker(world)).newDay();
        tickables.processPhase(IDailyTickable.Phase.POST);
        tickables.processPhase(IDailyTickable.Phase.LAST);
        HFTrackers.markDirty(world);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (!OfflineTickHandler.BLOCKED) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            WorldServer overworld = FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c[0];
            if (overworld.func_72820_D() % HFCalendar.TICKS_PER_DAY == 1L) {
                CalendarServer calendar = (CalendarServer)HFTrackers.getCalendar((World)overworld);
                CalendarDate yesterday = calendar.getDate();
                ((CalendarServer)HFTrackers.getCalendar((World)overworld)).newDay((World)overworld);
                CalendarDate today = calendar.getDate();
                for (PlayerTrackerServer player : HFTrackers.getPlayerTrackers()) {
                    player.newDay(yesterday, today);
                }
                AnimalTrackerServer.processQueue();
                DailyTickHandler.processQueue();
                for (WorldServer world : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
                    NewDayHandler.newDay((World)world);
                }
            }
            if (HFAnimals.OUTDOOR_HAPPINESS && overworld.func_72820_D() % HFCalendar.TWO_HOURS == 0L) {
                for (WorldServer world : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
                    ((AnimalTrackerServer)HFTrackers.getAnimalTracker((World)world)).biHourly();
                }
            }
        }
    }
}

