/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.handlers;

import java.util.List;
import joshie.harvest.core.HFCore;
import joshie.harvest.core.achievements.HFAchievements;
import joshie.harvest.core.block.BlockFlower;
import joshie.harvest.core.lib.HFSounds;
import joshie.harvest.core.util.HFEvents;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.npc.NPC;
import joshie.harvest.npc.NPCHelper;
import joshie.harvest.npc.entity.EntityNPCGoddess;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@HFEvents
public class GoddessHandler {
    private static Item goddess;
    public static long lastGoddess;

    public static boolean isGoddessFlower(ItemStack stack) {
        if (goddess == null) {
            goddess = Item.func_150898_a((Block)HFCore.FLOWERS);
        }
        return stack.func_77973_b() == goddess && stack.func_77952_i() == BlockFlower.FlowerType.GODDESS.ordinal();
    }

    public static boolean spawnGoddess(World world, Entity entity, boolean flower, boolean move) {
        return GoddessHandler.spawnGoddess(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, flower, move);
    }

    public static boolean spawnGoddess(World world, double x, double y, double z, boolean flower, boolean move) {
        EntityNPCGoddess goddess;
        List npcs = world.func_72872_a(EntityNPCGoddess.class, new AxisAlignedBB(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 0.5, z + 0.5).func_72314_b(32.0, 32.0, 32.0));
        boolean newGoddess = npcs.size() < 1;
        EntityNPCGoddess entityNPCGoddess = goddess = !newGoddess ? (EntityNPCGoddess)((Object)npcs.get(0)) : (EntityNPCGoddess)((Object)NPCHelper.getEntityForNPC(world, (NPC)HFNPCs.GODDESS));
        if (flower) {
            goddess.setFlower();
        }
        if (move || goddess.field_70165_t == 0.0 && goddess.field_70163_u == 0.0 && goddess.field_70161_v == 0.0) {
            goddess.func_70107_b(x, y + 1.0, z);
        }
        if (newGoddess) {
            world.func_72838_d((Entity)goddess);
        }
        return !newGoddess;
    }

    @SubscribeEvent
    public void onItemExpire(ItemExpireEvent event) {
        ItemStack stack;
        World world = event.getEntityItem().field_70170_p;
        if (!world.field_72995_K && GoddessHandler.isGoddessFlower(stack = event.getEntityItem().func_92059_d())) {
            if (event.getEntityItem().func_70055_a(Material.field_151586_h)) {
                GoddessHandler.spawnGoddess(world, (Entity)event.getEntityItem(), true, true);
            } else if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
                event.setExtraLife(5950);
                event.setCanceled(true);
            } else {
                stack.func_77982_d(null);
            }
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.RightClickBlock event) {
        if (System.currentTimeMillis() - lastGoddess >= 1000L) {
            TileEntityFlowerPot tile;
            World world = event.getWorld();
            BlockPos pos = event.getPos();
            ItemStack held = event.getItemStack();
            if (held != null && held.func_77973_b() == Items.field_151055_y && world.func_180495_p(pos).func_177230_c() == Blocks.field_150457_bL && (tile = (TileEntityFlowerPot)world.func_175625_s(pos)) != null && tile.func_145965_a() != null) {
                this.checkFlower(world, pos, event.getEntityPlayer());
            }
        }
    }

    private boolean isPlantlike(Block block) {
        return block instanceof IPlantable;
    }

    private void checkFlower(World world, BlockPos pos, EntityPlayer player) {
        Block xMinus = world.func_180495_p(pos.func_177982_a(-1, -1, 0)).func_177230_c();
        Block xPlus = world.func_180495_p(pos.func_177982_a(1, -1, 0)).func_177230_c();
        Block zMinus = world.func_180495_p(pos.func_177982_a(0, -1, -1)).func_177230_c();
        Block zPlus = world.func_180495_p(pos.func_177982_a(0, -1, 1)).func_177230_c();
        int water = 0;
        int flower = 0;
        if (xMinus == Blocks.field_150355_j) {
            ++water;
        }
        if (xPlus == Blocks.field_150355_j) {
            ++water;
        }
        if (zMinus == Blocks.field_150355_j) {
            ++water;
        }
        if (zPlus == Blocks.field_150355_j) {
            ++water;
        }
        xMinus = world.func_180495_p(pos.func_177982_a(-1, 0, 0)).func_177230_c();
        xPlus = world.func_180495_p(pos.func_177982_a(1, 0, 0)).func_177230_c();
        zMinus = world.func_180495_p(pos.func_177982_a(0, 0, -1)).func_177230_c();
        zPlus = world.func_180495_p(pos.func_177982_a(0, 0, 1)).func_177230_c();
        if (this.isPlantlike(xMinus)) {
            ++flower;
        }
        if (this.isPlantlike(xPlus)) {
            ++flower;
        }
        if (this.isPlantlike(zMinus)) {
            ++flower;
        }
        if (this.isPlantlike(zPlus)) {
            ++flower;
        }
        if (water == 2 && flower == 2 && !world.field_72995_K) {
            world.func_175718_b(2005, pos, 0);
            if (world.field_73012_v.nextInt(9) == 0) {
                world.func_175656_a(pos, HFCore.FLOWERS.getStateFromEnum(BlockFlower.FlowerType.GODDESS));
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, HFSounds.GODDESS_SPAWN, SoundCategory.NEUTRAL, 0.5f, 1.1f);
                player.func_71029_a((StatBase)HFAchievements.summon);
                lastGoddess = System.currentTimeMillis();
            }
        }
    }
}

