/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.handlers;

import joshie.harvest.animals.AnimalTrackerServer;
import joshie.harvest.api.ticking.IDailyTickable;
import joshie.harvest.calendar.CalendarServer;
import joshie.harvest.calendar.HFCalendar;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.handlers.OfflineTickHandler;
import joshie.harvest.core.handlers.TickDailyServer;
import joshie.harvest.core.helpers.MCServerHelper;
import joshie.harvest.core.util.HFEvents;
import joshie.harvest.player.PlayerTrackerServer;
import joshie.harvest.town.TownTrackerServer;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiWorldSelection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@HFEvents
public class EventsHandler {
    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (!OfflineTickHandler.BLOCKED) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            WorldServer overworld = FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c[0];
            if (overworld.func_72820_D() % HFCalendar.TICKS_PER_DAY == 1L) {
                ((CalendarServer)HFTrackers.getCalendar((World)overworld)).newDay((World)overworld);
                for (PlayerTrackerServer player : HFTrackers.getPlayerTrackers()) {
                    player.newDay();
                }
                AnimalTrackerServer.processQueue();
                TickDailyServer.processQueue();
                for (WorldServer world : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
                    EventsHandler.newDay((World)world);
                }
            }
        }
    }

    public static void newDay(World world) {
        HFTrackers.getTickables(world).newDay(IDailyTickable.Phase.PRE);
        ((AnimalTrackerServer)HFTrackers.getAnimalTracker(world)).newDay();
        ((TownTrackerServer)HFTrackers.getTownTracker(world)).newDay();
        HFTrackers.getTickables(world).newDay(IDailyTickable.Phase.POST);
        HFTrackers.markDirty(world);
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            ((PlayerTrackerServer)HFTrackers.getPlayerTrackerFromPlayer((EntityPlayer)player)).getStats().setBirthday((World)FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c[0]);
            ((CalendarServer)HFTrackers.getCalendar(player.field_70170_p)).syncToPlayer((EntityPlayer)player);
            ((TownTrackerServer)HFTrackers.getTownTracker(event.player.field_70170_p)).syncToPlayer((EntityPlayer)player);
            ((PlayerTrackerServer)HFTrackers.getPlayerTrackerFromPlayer((EntityPlayer)player)).syncPlayerStats(player);
        }
    }

    @SubscribeEvent
    public void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            ((TownTrackerServer)HFTrackers.getTownTracker(MCServerHelper.getWorld(event.toDim))).syncToPlayer(event.player);
        }
    }

    @HFEvents
    public static class ClientReset {
        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void onOpenGui(GuiOpenEvent event) {
            if (event.getGui() instanceof GuiWorldSelection || event.getGui() instanceof GuiMultiplayer) {
                HFTrackers.resetClient();
            }
        }
    }
}

