/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.handlers;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import joshie.harvest.animals.HFAnimals;
import joshie.harvest.core.util.HFEvents;
import joshie.harvest.core.util.holder.HolderRegistrySet;
import joshie.harvest.crops.HFCrops;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class DisableHandler {
    public static final Set<Block> CROPS = new HashSet<Block>();
    public static final HolderRegistrySet BLACKLIST = new HolderRegistrySet();

    @HFEvents
    public static class SeedDrops {
        public static boolean register() {
            return HFCrops.DISABLE_VANILLA_WHEAT_SEEDS;
        }

        @SubscribeEvent
        public void onItemDropping(BlockEvent.HarvestDropsEvent event) {
            if (event.getState().func_177230_c() == Blocks.field_150329_H || event.getState().func_177230_c() == Blocks.field_150398_cm) {
                Iterator it = event.getDrops().iterator();
                while (it.hasNext()) {
                    if (!BLACKLIST.contains((ItemStack)it.next())) continue;
                    it.remove();
                }
            }
        }
    }

    @HFEvents
    public static class DisableHoes {
        public static boolean register() {
            return HFCrops.DISABLE_VANILLA_HOE;
        }

        @SubscribeEvent
        public void onUseHoe(UseHoeEvent event) {
            if (HFCrops.DISABLE_VANILLA_HOE && event.getCurrent().func_77973_b() instanceof ItemHoe) {
                event.setCanceled(true);
            }
        }
    }

    @HFEvents
    public static class DisableEggSpawning {
        public static boolean register() {
            return HFAnimals.DISABLE_SPAWN_CHICKEN;
        }

        @SubscribeEvent
        public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
            ItemStack held = event.getItemStack();
            if (held != null && held.func_77973_b() == Items.field_151110_aK) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @HFEvents
    public static class VanillaDrops {
        public static boolean register() {
            return HFCrops.DISABLE_VANILLA_DROPS;
        }

        @SubscribeEvent
        public void onHarvestBlock(BlockEvent.HarvestDropsEvent event) {
            if (CROPS.contains(event.getState().func_177230_c())) {
                event.getDrops().clear();
            }
        }
    }

    @HFEvents
    public static class VanillaGrowth {
        public static boolean register() {
            return HFCrops.DISABLE_VANILLA_GROWTH;
        }

        @SubscribeEvent
        public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
            if (CROPS.contains(event.getWorld().func_180495_p(event.getPos()).func_177230_c())) {
                event.setUseItem(Event.Result.DENY);
            }
        }
    }

    @HFEvents
    public static class DisableVanillaSeeds {
        public static boolean register() {
            return HFCrops.DISABLE_VANILLA_SEEDS;
        }

        @SubscribeEvent
        public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
            ItemStack held = event.getItemStack();
            if (held != null && BLACKLIST.contains(held)) {
                event.setUseItem(Event.Result.DENY);
                return;
            }
        }
    }
}

