/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.handlers;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import joshie.harvest.api.ticking.IDailyTickable;
import joshie.harvest.api.ticking.IDailyTickableBlock;
import joshie.harvest.core.HFTrackers;
import joshie.harvest.core.util.HFTracker;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DailyTickHandler
extends HFTracker {
    private static final Set<Runnable> queue = new HashSet<Runnable>();
    private final Multimap<IDailyTickable.Phase, IDailyTickable> tickables = HashMultimap.create();
    private final HashMap<BlockPos, IDailyTickableBlock> blockTicks = new HashMap();

    public static void addToQueue(Runnable runnable) {
        queue.add(runnable);
    }

    static void processQueue() {
        HashSet<Runnable> toProcess = new HashSet<Runnable>(queue);
        queue.clear();
        toProcess.forEach(Runnable::run);
    }

    void processPhase(IDailyTickable.Phase phase) {
        this.processTickables(this.tickables.get((Object)phase));
    }

    void processBlocks() {
        World world = this.getWorld();
        Iterator<Map.Entry<BlockPos, IDailyTickableBlock>> position = this.blockTicks.entrySet().iterator();
        while (position.hasNext()) {
            Map.Entry<BlockPos, IDailyTickableBlock> entry = position.next();
            BlockPos pos = entry.getKey();
            if (pos == null) {
                position.remove();
                continue;
            }
            if (!world.func_175667_e(pos)) continue;
            IBlockState state = this.getWorld().func_180495_p(pos);
            IDailyTickableBlock tickable = entry.getValue();
            if (tickable != null) {
                if (tickable.newDay(this.getWorld(), pos, state)) continue;
                position.remove();
                continue;
            }
            position.remove();
        }
    }

    private void processTickables(Collection<IDailyTickable> tickables) {
        Iterator<IDailyTickable> ticking = tickables.iterator();
        while (ticking.hasNext()) {
            IDailyTickable tickable = ticking.next();
            if (tickable == null || ((TileEntity)tickable).func_145837_r()) {
                ticking.remove();
                continue;
            }
            tickable.newDay();
        }
    }

    public void add(BlockPos pos, IDailyTickableBlock daily) {
        this.blockTicks.put(pos, daily);
        HFTrackers.markDirty(this.getDimension());
    }

    public void remove(BlockPos pos) {
        this.blockTicks.remove(pos);
        HFTrackers.markDirty(this.getDimension());
    }

    public void add(IDailyTickable tickable) {
        for (IDailyTickable.Phase phase : tickable.getPhases()) {
            this.tickables.get((Object)phase).add(tickable);
        }
    }

    public void remove(IDailyTickable tickable) {
        for (IDailyTickable.Phase phase : tickable.getPhases()) {
            this.tickables.get((Object)phase).remove(tickable);
        }
    }
}

