/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.config;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import joshie.harvest.HarvestFestival;
import joshie.harvest.core.config.ASM;
import joshie.harvest.core.helpers.generic.ConfigHelper;
import joshie.harvest.plugins.HFPlugins;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Level;

public class HFConfig {
    public static ASM asm;

    public static void preInit() {
        HFConfig.initConfig("General");
        HFConfig.initConfig("Animals");
        HFConfig.initConfig("Calendar");
        HFConfig.initConfig("Cooking");
        HFConfig.initConfig("Crops");
        HFConfig.initConfig("NPC");
        HFPlugins.loadConfigs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initConfig(String name) {
        Configuration config = new Configuration(new File(HarvestFestival.root, name.replaceAll("(.)([A-Z])", "$1-$2").toLowerCase() + ".cfg"));
        try {
            config.load();
            ConfigHelper.setConfig(config);
            Class<?> clazz = Class.forName("joshie.harvest.core.config." + name);
            Method method = clazz.getMethod("init", new Class[0]);
            method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            HarvestFestival.LOGGER.log(Level.ERROR, "Harvest Festival failed to load in it's " + name + " config");
            e.printStackTrace();
        }
        finally {
            config.save();
        }
    }

    public static void initASM(Gson gson) {
        File file = new File("config/harvestfestival/vanilla.json");
        if (!file.exists()) {
            try {
                asm = new ASM();
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
                writer.write(gson.toJson((Object)asm));
                ((Writer)writer).close();
            }
            catch (Exception exception) {}
        } else {
            try {
                asm = (ASM)gson.fromJson(FileUtils.readFileToString((File)file), ASM.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

