/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.commands;

import joshie.harvest.api.HFApi;
import joshie.harvest.api.calendar.Weather;
import joshie.harvest.calendar.CalendarHelper;
import joshie.harvest.calendar.CalendarServer;
import joshie.harvest.calendar.HFCalendar;
import joshie.harvest.core.handlers.HFTrackers;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;

public class VanillaCommands {
    public static boolean isHandled(String name) {
        return name.equals("time") || name.equals("weather") || name.equals("toggledownfall");
    }

    public static boolean executeVanillaTime(MinecraftServer server, ICommandSender sender, String[] args) throws NumberInvalidException {
        if (args.length > 1 && args[0].equals("set")) {
            long time = (long)CalendarHelper.getElapsedDays(server.field_71305_c[0].func_72820_D()) * HFCalendar.TICKS_PER_DAY;
            switch (args[1]) {
                case "force-day": {
                    time = 1000L;
                    break;
                }
                case "force-night": {
                    time = 13000L;
                    break;
                }
                case "force": {
                    time = CommandBase.func_175755_a((String)args[1]);
                    break;
                }
                case "day": {
                    time += 3000L;
                    break;
                }
                case "night": {
                    time += 18000L;
                    break;
                }
                default: {
                    time += (long)CommandBase.func_175755_a((String)args[1]);
                }
            }
            CalendarHelper.setWorldTime(server, time);
            return true;
        }
        return false;
    }

    public static boolean executeVanillaWeather(MinecraftServer server, ICommandSender sender, String[] args) throws WrongUsageException {
        if (args.length >= 1 && args.length <= 2) {
            if ("clear".equalsIgnoreCase(args[0])) {
                ((CalendarServer)HFTrackers.getCalendar((World)server.field_71305_c[0])).setTodaysWeather(Weather.SUNNY);
            } else if ("rain".equalsIgnoreCase(args[0])) {
                ((CalendarServer)HFTrackers.getCalendar((World)server.field_71305_c[0])).setTodaysWeather(Weather.RAIN);
            } else {
                if (!"thunder".equalsIgnoreCase(args[0])) {
                    throw new WrongUsageException("commands.weather.usage", new Object[0]);
                }
                ((CalendarServer)HFTrackers.getCalendar((World)server.field_71305_c[0])).setTodaysWeather(Weather.TYPHOON);
            }
            return true;
        }
        throw new WrongUsageException("commands.weather.usage", new Object[0]);
    }

    public static boolean executeToggleDownfall(MinecraftServer server, ICommandSender sender, String[] args) throws WrongUsageException {
        if (HFApi.calendar.getWeather((World)server.field_71305_c[0]).isSunny()) {
            ((CalendarServer)HFTrackers.getCalendar((World)server.field_71305_c[0])).setTodaysWeather(Weather.RAIN);
            return true;
        }
        ((CalendarServer)HFTrackers.getCalendar((World)server.field_71305_c[0])).setTodaysWeather(Weather.SUNNY);
        return true;
    }
}

