/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import joshie.harvest.core.commands.AbstractHFCommand;
import joshie.harvest.core.commands.HFCommandHelp;
import joshie.harvest.core.commands.VanillaCommands;
import joshie.harvest.core.helpers.MCClientHelper;
import joshie.harvest.core.util.HFEvents;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@HFEvents
public class CommandManager
extends CommandBase {
    public static final CommandManager INSTANCE = new CommandManager();
    private final HashMap<String, AbstractHFCommand> commands = new HashMap();

    public void registerCommand(AbstractHFCommand command) {
        this.commands.put(command.getCommandName(), command);
    }

    public Map<String, AbstractHFCommand> getCommands() {
        return this.commands;
    }

    public List<AbstractHFCommand> getPossibleCommands(ICommandSender sender) {
        ArrayList<AbstractHFCommand> list = new ArrayList<AbstractHFCommand>();
        for (AbstractHFCommand command : this.commands.values()) {
            if (!sender.func_70003_b(command.getPermissionLevel().ordinal(), command.getCommandName())) continue;
            list.add(command);
        }
        return list;
    }

    public String func_71517_b() {
        return "hf";
    }

    private World getWorld(ICommandSender sender) {
        if (sender instanceof EntityPlayer) {
            return ((EntityPlayer)sender).field_70170_p;
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            return FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_();
        }
        return MCClientHelper.getWorld();
    }

    @SubscribeEvent
    public void onCommandSend(CommandEvent event) throws CommandException {
        if (VanillaCommands.isHandled(event.getCommand().func_71517_b())) {
            String name = event.getCommand().func_71517_b();
            try {
                if (name.equals("time") && VanillaCommands.executeVanillaTime(FMLCommonHandler.instance().getMinecraftServerInstance(), event.getSender(), event.getParameters())) {
                    event.setCanceled(true);
                } else if (name.equals("weather") && VanillaCommands.executeVanillaWeather(FMLCommonHandler.instance().getMinecraftServerInstance(), event.getSender(), event.getParameters())) {
                    event.setCanceled(true);
                } else if (name.equals("toggledownfall") && VanillaCommands.executeToggleDownfall(FMLCommonHandler.instance().getMinecraftServerInstance(), event.getSender(), event.getParameters())) {
                    event.setCanceled(true);
                }
            }
            catch (Exception exception) {}
        } else if (event.getCommand() == this && event.getParameters().length > 0) {
            if (this.getWorld((ICommandSender)event.getSender()).field_72995_K) {
                event.setCanceled(true);
            } else {
                String commandName = event.getParameters()[0];
                AbstractHFCommand command = this.commands.get(commandName);
                if (command == null || !event.getSender().func_70003_b(command.getPermissionLevel().ordinal(), commandName)) {
                    event.setCanceled(true);
                } else {
                    this.processCommand(event, command);
                }
            }
        }
    }

    private void processCommand(CommandEvent event, AbstractHFCommand command) throws CommandException {
        String[] args = new String[event.getParameters().length - 1];
        System.arraycopy(event.getParameters(), 1, args, 0, args.length);
        if (!command.execute(FMLCommonHandler.instance().getMinecraftServerInstance(), event.getSender(), args)) {
            CommandManager.throwError(event.getSender(), command);
        }
    }

    static void throwError(ICommandSender sender, AbstractHFCommand command) {
        TextComponentTranslation textComponents = new TextComponentTranslation(CommandManager.getUsage(command), new Object[]{0});
        textComponents.func_150256_b().func_150238_a(TextFormatting.RED);
        sender.func_145747_a((ITextComponent)textComponents);
    }

    static String getUsage(AbstractHFCommand command) {
        return command.getUsage();
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] parameters, BlockPos pos) {
        return new ArrayList<String>();
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.func_71517_b() + " help";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] values) {
        if (values.length == 0) {
            CommandManager.throwError(sender, new HFCommandHelp());
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }
}

