/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.block;

import java.util.Locale;
import joshie.harvest.api.HFApi;
import joshie.harvest.core.base.block.BlockHFEnumRotatableTile;
import joshie.harvest.core.handlers.HFTrackers;
import joshie.harvest.core.helpers.EntityHelper;
import joshie.harvest.core.tile.TileShipping;
import joshie.harvest.player.PlayerTrackerServer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockStorage
extends BlockHFEnumRotatableTile<BlockStorage, Storage> {
    private static final AxisAlignedBB SHIPPING_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.6, 1.0);

    public BlockStorage() {
        super(Material.field_151575_d, Storage.class);
        this.setHardness(1.5f);
        this.func_149672_a(SoundType.field_185848_a);
    }

    @Override
    public String getToolType(Storage storage) {
        return "axe";
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        Storage storage = (Storage)((Object)this.getEnumFromState(state));
        switch (storage) {
            case SHIPPING: {
                return SHIPPING_AABB;
            }
        }
        return field_185505_j;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack held, EnumFacing side, float hitX, float hitY, float hitZ) {
        long sell;
        Storage storage = (Storage)((Object)this.getEnumFromState(state));
        if (player.func_70093_af()) {
            return false;
        }
        if (storage == Storage.SHIPPING && held != null && (sell = HFApi.shipping.getSellValue(held)) > 0L) {
            if (!world.field_72995_K) {
                ((PlayerTrackerServer)HFTrackers.getPlayerTrackerFromPlayer(player)).getTracking().addForShipping(held.func_77946_l());
            }
            held.func_77979_a(1);
            return true;
        }
        return false;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        EntityItem item;
        if (entity instanceof EntityItem && (item = (EntityItem)entity).func_145800_j() != null) {
            EntityPlayer player = world.func_72924_a(item.func_145800_j());
            ItemStack stack = item.func_92059_d();
            long sell = HFApi.shipping.getSellValue(stack);
            if (sell > 0L) {
                if (!world.field_72995_K) {
                    ((PlayerTrackerServer)HFTrackers.getPlayerTrackerFromPlayer(player)).getTracking().addForShipping(stack.func_77946_l());
                }
                stack.func_77979_a(1);
                if (stack.field_77994_a <= 0) {
                    item.func_70106_y();
                }
            }
        }
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        if (entity instanceof EntityPlayer && this.getEnumFromState(state) == Storage.SHIPPING) {
            ((TileShipping)world.func_175625_s(pos)).setOwner(EntityHelper.getPlayerUUID((EntityPlayer)entity));
        }
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileShipping();
    }

    @Override
    public int getSortValue(ItemStack stack) {
        return 10;
    }

    public static enum Storage implements IStringSerializable
    {
        SHIPPING;


        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }
    }
}

