/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.block;

import java.util.List;
import java.util.Locale;
import joshie.harvest.core.HFTab;
import joshie.harvest.core.base.block.BlockHFEnum;
import joshie.harvest.core.util.Text;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFlower
extends BlockHFEnum<BlockFlower, FlowerType>
implements IPlantable {
    protected static final AxisAlignedBB FLOWER_AABB = new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, (double)0.7f, (double)0.6f, (double)0.7f);

    public BlockFlower() {
        super(Material.field_151585_k, FlowerType.class, HFTab.GATHERING);
        this.func_149672_a(SoundType.field_185850_c);
    }

    @Override
    public long getSellValue(ItemStack stack) {
        return this.getEnumFromStack(stack) == FlowerType.WEED ? 1L : 0L;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        IBlockState soil = world.func_180495_p(pos.func_177977_b());
        return super.func_176196_c(world, pos) && this.canBlockStay(world, pos.func_177977_b(), soil);
    }

    protected boolean canSustainBush(IBlockState state) {
        return state.func_185904_a() == Material.field_151578_c;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock) {
        super.func_189540_a(state, world, pos, neighborBlock);
        this.checkAndDropBlock(world, pos, state);
    }

    protected void checkAndDropBlock(World world, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(world, pos, state)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this) {
            IBlockState soil = world.func_180495_p(pos.func_177977_b());
            return soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
        }
        return this.canSustainBush(world.func_180495_p(pos.func_177977_b()));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return FLOWER_AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, World world, BlockPos pos) {
        return field_185506_k;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return this.func_176223_P();
    }

    @Override
    public int getEntityLifeSpan(ItemStack stack, World world) {
        return stack.func_77952_i() == FlowerType.GODDESS.ordinal() ? 50 : 6000;
    }

    @Override
    public String getItemStackDisplayName(ItemStack stack) {
        return this.getEnumFromMeta(stack.func_77952_i()) == FlowerType.GODDESS ? TextFormatting.AQUA + super.getItemStackDisplayName(stack) : super.getItemStackDisplayName(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List<String> list, boolean flag) {
        if (this.getEnumFromMeta(stack.func_77952_i()) == FlowerType.GODDESS) {
            list.add(Text.translate("tooltip.flower"));
        }
    }

    @Override
    public int getSortValue(ItemStack stack) {
        return -99;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(Item item, String name) {
        for (int i = 0; i < ((FlowerType[])this.values).length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("harvestfestival", this.property.func_177701_a() + "_" + ((FlowerType)((Object)this.getEnumFromMeta(i))).func_176610_l()), "inventory"));
        }
    }

    public static enum FlowerType implements IStringSerializable
    {
        GODDESS,
        WEED;


        public boolean isColored() {
            return this == WEED;
        }

        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }
    }
}

