/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.base.tile;

import joshie.harvest.api.core.ISizeable;
import joshie.harvest.core.base.tile.TileDaily;
import joshie.harvest.core.helpers.MCServerHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileFillableSized
extends TileDaily {
    protected int fillAmount = 0;
    protected ISizeable.Size size = ISizeable.Size.MEDIUM;

    public abstract boolean onActivated(EntityPlayer var1, ItemStack var2);

    public ISizeable.Size getSize() {
        if (this.size == null) {
            this.size = ISizeable.Size.MEDIUM;
        }
        return this.size;
    }

    public int getFillAmount() {
        return this.fillAmount;
    }

    public void add(ISizeable.Size size, int amount) {
        this.setFilled(size, this.fillAmount + amount);
    }

    public void setFilled(ISizeable.Size size, int isFilled) {
        this.fillAmount = isFilled;
        this.size = size;
        this.saveAndRefresh();
    }

    @Override
    public void saveAndRefresh() {
        MCServerHelper.markForUpdate(this.field_145850_b, this.func_174877_v(), 3);
        this.func_70296_d();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.fillAmount = nbt.func_74771_c("IsFilled");
        this.size = ISizeable.Size.values()[nbt.func_74771_c("Size")];
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74774_a("IsFilled", (byte)this.fillAmount);
        nbt.func_74774_a("Size", (byte)this.getSize().ordinal());
        return super.func_189515_b(nbt);
    }
}

