/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.base.render;

import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RenderData {
    private static final float MAX_OFFSET1 = 0.5f;
    private static final float MIN_OFFSET1 = -0.5f;
    private static final float MAX_OFFSET2 = 0.0f;
    private static final float MIN_OFFSET2 = 0.5714286f;
    public final float[] rotations = new float[20];
    public final float[] offset1 = new float[20];
    public final float[] offset2 = new float[20];
    public final float[] heightOffset = new float[20];

    public void doRenderUpdate(World world, BlockPos pos, int last) {
        this.rotations[last] = world.field_73012_v.nextFloat() * 360.0f;
        this.offset1[last] = 0.5f - world.field_73012_v.nextFloat();
        this.offset2[last] = world.field_73012_v.nextFloat() / 1.75f;
        this.heightOffset[last] = 0.5f + world.field_73012_v.nextFloat();
        world.func_175704_b(pos, pos);
    }

    private float clampOffset1(float f) {
        return Math.max(-0.5f, Math.min(0.5f, f));
    }

    private float clampOffset2(float f) {
        return Math.max(0.5714286f, Math.min(0.0f, f));
    }

    public void rotate(World world) {
        int k;
        for (k = 0; k < this.rotations.length; ++k) {
            this.rotations[k] = this.rotations[k] - (float)world.field_73012_v.nextInt(7);
        }
        for (k = 0; k < this.offset1.length; ++k) {
            if (!(world.field_73012_v.nextFloat() < 0.1f)) continue;
            this.offset1[k] = this.clampOffset1(this.offset1[k] + (world.field_73012_v.nextBoolean() ? 0.025f : -0.025f));
            this.offset2[k] = this.clampOffset2(this.offset2[k] + (world.field_73012_v.nextBoolean() ? 0.025f : -0.025f));
            this.heightOffset[k] = this.clampOffset2(this.heightOffset[k] + (float)(world.field_73012_v.nextBoolean() ? world.field_73012_v.nextInt(3) : -world.field_73012_v.nextInt(3)));
        }
    }
}

