/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.base.item;

import java.util.Set;
import joshie.harvest.api.core.ITiered;
import joshie.harvest.api.gathering.ISmashable;
import joshie.harvest.core.base.item.ItemTool;
import joshie.harvest.core.helpers.EntityHelper;
import joshie.harvest.tools.ToolHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class ItemToolSmashing
extends ItemTool<ItemToolSmashing> {
    public ItemToolSmashing(String toolClass, Set<Block> effective) {
        super(toolClass, effective);
    }

    @Override
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.NONE;
    }

    @Override
    public int getFront(ITiered.ToolTier tier) {
        switch (tier) {
            case BASIC: {
                return 0;
            }
            case COPPER: {
                return 1;
            }
            case SILVER: {
                return 2;
            }
            case GOLD: {
                return 3;
            }
            case MYSTRIL: {
                return 5;
            }
            case CURSED: 
            case BLESSED: {
                return 7;
            }
            case MYTHIC: {
                return 15;
            }
        }
        return 0;
    }

    @Override
    protected int getXMinus(ITiered.ToolTier tier, EnumFacing facing, int x) {
        return x - this.getFront(tier);
    }

    @Override
    protected int getXPlus(ITiered.ToolTier tier, EnumFacing facing, int x) {
        return x + this.getFront(tier);
    }

    @Override
    protected int getZMinus(ITiered.ToolTier tier, EnumFacing facing, int z) {
        return z - this.getFront(tier);
    }

    @Override
    protected int getZPlus(ITiered.ToolTier tier, EnumFacing facing, int z) {
        return z + this.getFront(tier);
    }

    public abstract ISmashable.ToolType getToolType();

    public abstract void playSound(World var1, BlockPos var2);

    public boolean onSmashed(EntityPlayer player, ItemStack stack, ITiered.ToolTier tier, int harvestLevel, World world, BlockPos pos, IBlockState state) {
        ISmashable smashable;
        int requiredLevel;
        if (this.canUse(stack) && state.func_177230_c() instanceof ISmashable && harvestLevel >= (requiredLevel = state.func_177230_c().getHarvestLevel(state)) && (smashable = (ISmashable)state.func_177230_c()).getToolType() == this.getToolType() && smashable.smashBlock(player, world, pos, state, tier)) {
            ToolHelper.performTask(player, stack, this.getExhaustionRate(stack));
            if (!world.field_72995_K) {
                this.func_179218_a(stack, world, state, pos, (EntityLivingBase)player);
            }
            return true;
        }
        return false;
    }

    public void smashBlock(World world, EntityPlayer player, BlockPos position, ItemStack stack, boolean jump) {
        ITiered.ToolTier tier = jump ? this.getTier(stack) : ITiered.ToolTier.BASIC;
        int harvestLevel = this.getHarvestLevel(stack, this.toolClass);
        boolean smashed = false;
        EnumFacing front = EntityHelper.getFacingFromEntity((EntityLivingBase)player);
        for (int x = this.getXMinus(tier, front, position.func_177958_n()); x <= this.getXPlus(tier, front, position.func_177958_n()); ++x) {
            for (int z = this.getZMinus(tier, front, position.func_177952_p()); z <= this.getZPlus(tier, front, position.func_177952_p()); ++z) {
                IBlockState state;
                BlockPos pos = new BlockPos(x, position.func_177956_o(), z);
                if (!this.onSmashed(player, stack, tier, harvestLevel, world, pos, state = world.func_180495_p(pos))) continue;
                smashed = true;
            }
        }
        if (smashed && jump) {
            world.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (double)position.func_177958_n() + 0.5, (double)position.func_177956_o() + 0.5, (double)position.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[0]);
            this.playSound(world, position);
        }
    }
}

