/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.base.item;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Set;
import javax.annotation.Nullable;
import joshie.harvest.api.core.ITiered;
import joshie.harvest.core.base.item.ItemTool;
import joshie.harvest.core.helpers.ChatHelper;
import joshie.harvest.core.util.Text;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemToolChargeable
extends ItemTool<ItemToolChargeable> {
    public static final TIntObjectMap<ITiered.ToolTier> LEVEL_TO_TIER = new TIntObjectHashMap();

    public ItemToolChargeable(String toolClass, Set<Block> effective) {
        super(toolClass, effective);
    }

    protected int getMaxCharge(ItemStack stack) {
        return this.getTier(stack).getToolLevel();
    }

    protected boolean canCharge(ItemStack stack) {
        NBTTagCompound tag = stack.func_179543_a("Data", true);
        int amount = tag.func_74762_e("Charge");
        return amount < this.getMaxCharge(stack);
    }

    protected int getCharge(ItemStack stack) {
        return stack.func_179543_a("Data", true).func_74762_e("Charge");
    }

    protected void setCharge(ItemStack stack, int amount) {
        stack.func_179543_a("Data", true).func_74768_a("Charge", amount);
    }

    protected void increaseCharge(ItemStack stack, int amount) {
        this.setCharge(stack, this.getCharge(stack) + amount);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer playerIn, EnumHand hand) {
        ITiered.ToolTier tier = this.getTier(stack);
        if (tier != ITiered.ToolTier.BASIC && this.canUse(stack)) {
            if (playerIn.func_70093_af()) {
                this.setCharge(stack, 0);
                if (world.field_72995_K) {
                    ChatHelper.displayChat(TextFormatting.RED + Text.translate("tool.discharge"));
                }
            } else if (this.getCharge(stack) < this.getMaxCharge(stack)) {
                playerIn.func_184598_c(hand);
            } else {
                this.func_77615_a(stack, world, (EntityLivingBase)playerIn, 32000);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (tier == ITiered.ToolTier.BASIC && this.canUse(stack)) {
            this.func_77615_a(stack, world, (EntityLivingBase)playerIn, 32000);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    private int getCharges(int count) {
        int passed = 32000 - count;
        return passed / 20;
    }

    protected String getLevelName(ItemStack stack, int charges) {
        int newCharge;
        int maximum = this.getMaxCharge(stack);
        int charge = this.getCharge(stack);
        return charge == (newCharge = Math.min(maximum, charge + charges)) ? null : "" + newCharge;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        String name;
        if (count != 32000 && count % 20 == 0 && player.field_70170_p.field_72995_K && (name = this.getLevelName(stack, this.getCharges(count))) != null) {
            ChatHelper.displayChat(TextFormatting.GREEN + Text.formatHF("tool.charge", name));
        }
    }

    private ITiered.ToolTier getChargeTier(int charge) {
        return (ITiered.ToolTier)((Object)LEVEL_TO_TIER.get(charge));
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int timeLeft) {
        int maximum = this.getMaxCharge(stack);
        int charge = this.getCharge(stack);
        int newCharge = Math.min(maximum, charge + this.getCharges(timeLeft));
        if (charge < maximum) {
            this.setCharge(stack, newCharge);
        }
        this.onFinishedCharging(world, entity, this.getMovingObjectPositionFromPlayer(world, entity), stack, this.getChargeTier(newCharge));
    }

    protected void onFinishedCharging(World world, EntityLivingBase entity, @Nullable RayTraceResult result, ItemStack stack, ITiered.ToolTier toolTier) {
    }

    static {
        for (ITiered.ToolTier tier : ITiered.ToolTier.values()) {
            if (tier == ITiered.ToolTier.BLESSED) continue;
            LEVEL_TO_TIER.put(tier.getToolLevel(), (Object)tier);
        }
    }
}

