/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.core.base.item;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import joshie.harvest.api.core.ITiered;
import joshie.harvest.core.HFCore;
import joshie.harvest.core.base.item.ItemHFBase;
import joshie.harvest.core.helpers.InventoryHelper;
import joshie.harvest.core.util.ICreativeSorted;
import joshie.harvest.core.util.Text;
import joshie.harvest.mining.HFMining;
import joshie.harvest.mining.item.ItemMaterial;
import joshie.harvest.tools.ToolHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemTool<I extends ItemTool>
extends ItemHFBase<I>
implements ITiered,
ICreativeSorted {
    private final Set<Block> effectiveBlocks;
    protected final String toolClass;

    public ItemTool(String toolClass, Set<Block> effective) {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.effectiveBlocks = effective;
        this.toolClass = toolClass;
    }

    public ItemStack getStack(ITiered.ToolTier tier) {
        return new ItemStack((Item)this, 1, tier.ordinal());
    }

    @Override
    public int getSortValue(ItemStack stack) {
        return 1 + this.getTier(stack).ordinal();
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "_" + this.getTier(stack).name().toLowerCase(Locale.ENGLISH);
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        return Text.localize(super.func_77658_a().replace("item.", "") + "." + this.getTier(stack).name().toLowerCase(Locale.ENGLISH));
    }

    @Override
    public double getLevel(ItemStack stack) {
        return stack.func_179543_a("Data", true).func_74769_h("Level");
    }

    @Override
    public void levelTool(ItemStack stack) {
        double level = stack.func_179543_a("Data", true).func_74769_h("Level");
        double increase = this.getLevelIncrease(stack);
        double newLevel = Math.min(100.0, level + increase);
        stack.func_179543_a("Data", true).func_74780_a("Level", newLevel);
    }

    @Override
    public boolean setLevel(ItemStack stack, double newLevel) {
        if (newLevel < 0.0 || newLevel > 100.0) {
            return false;
        }
        stack.func_179543_a("Data", true).func_74780_a("Level", newLevel);
        return true;
    }

    @Override
    public ITiered.ToolTier getTier(ItemStack stack) {
        int safe = Math.min(Math.max(0, stack.func_77952_i()), ITiered.ToolTier.values().length - 1);
        return ITiered.ToolTier.values()[safe];
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getDurabilityForDisplay(stack) > 0.0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)this.getDamageForDisplay(stack) / (double)this.getMaximumToolDamage(stack);
    }

    public boolean canBeDamaged() {
        return true;
    }

    public int getDamageForDisplay(ItemStack stack) {
        return stack.func_179543_a("Data", true).func_74762_e("Damage");
    }

    public boolean canUse(ItemStack stack) {
        return this.getDamageForDisplay(stack) + 1 < this.getMaximumToolDamage(stack) || !this.canBeDamaged();
    }

    private boolean canLevel(ItemStack stack, IBlockState state) {
        for (String type : this.getToolClasses(stack)) {
            if (!state.func_177230_c().isToolEffective(type, state)) continue;
            return true;
        }
        return this.effectiveBlocks.contains(state.func_177230_c());
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if (this.canBeDamaged()) {
            if (this.canLevel(stack, state)) {
                ToolHelper.levelTool(stack);
            }
            stack.func_179543_a("Data", true).func_74768_a("Damage", this.getDamageForDisplay(stack) + 1);
        }
        return true;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 32000;
    }

    public int getFront(ITiered.ToolTier tier) {
        return 0;
    }

    public int getSides(ITiered.ToolTier tier) {
        return 0;
    }

    public float getExhaustionRate(ItemStack stack) {
        ITiered.ToolTier tier = this.getTier(stack);
        switch (tier) {
            case BASIC: {
                return 3.0f;
            }
            case COPPER: {
                return 2.5f;
            }
            case SILVER: 
            case GOLD: {
                return 2.0f;
            }
            case MYSTRIL: {
                return 1.5f;
            }
            case CURSED: {
                return 10.0f;
            }
            case BLESSED: {
                return 1.0f;
            }
            case MYTHIC: {
                return 0.5f;
            }
        }
        return 1.0f;
    }

    public double getLevelIncrease(ItemStack stack) {
        ITiered.ToolTier tier = this.getTier(stack);
        switch (tier) {
            case BASIC: {
                return 0.39215682745098;
            }
            case COPPER: {
                return 0.196078431372549;
            }
            case SILVER: 
            case GOLD: {
                return 0.130718954248366;
            }
            case MYSTRIL: {
                return 0.0980392156862745;
            }
            case CURSED: 
            case BLESSED: {
                return 0.0784313725490196;
            }
            case MYTHIC: {
                return 0.0392156862745098;
            }
        }
        return 0.0;
    }

    public int getMaximumToolDamage(ItemStack stack) {
        ITiered.ToolTier tier = this.getTier(stack);
        switch (tier) {
            case BASIC: {
                return 256;
            }
            case COPPER: {
                return 512;
            }
            case SILVER: {
                return 1024;
            }
            case GOLD: {
                return 2048;
            }
            case MYSTRIL: {
                return 4096;
            }
            case CURSED: 
            case BLESSED: {
                return 8192;
            }
            case MYTHIC: {
                return 16384;
            }
        }
        return 0;
    }

    public float getEffiency(ItemStack stack) {
        ITiered.ToolTier tier = this.getTier(stack);
        float effiency = 0.0f;
        switch (tier) {
            case BASIC: {
                effiency = 1.25f;
                break;
            }
            case COPPER: {
                effiency = 2.5f;
                break;
            }
            case SILVER: {
                effiency = 5.0f;
                break;
            }
            case GOLD: {
                effiency = 7.5f;
                break;
            }
            case MYSTRIL: {
                effiency = 10.0f;
                break;
            }
            case CURSED: 
            case BLESSED: {
                effiency = 15.0f;
                break;
            }
            case MYTHIC: {
                effiency = 20.0f;
            }
        }
        return (float)Math.max((double)effiency, (this.getLevel(stack) + 1.0) / 50.0 * (double)effiency);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        if (!toolClass.equals(this.toolClass)) {
            return 0;
        }
        if (!this.canUse(stack)) {
            return 0;
        }
        ITiered.ToolTier tier = this.getTier(stack);
        switch (tier) {
            case BASIC: {
                return 1;
            }
            case COPPER: {
                return 2;
            }
            case SILVER: {
                return 3;
            }
            case GOLD: {
                return 4;
            }
            case MYSTRIL: {
                return 5;
            }
            case CURSED: 
            case BLESSED: {
                return 6;
            }
            case MYTHIC: {
                return 7;
            }
        }
        return 0;
    }

    protected int getXMinus(ITiered.ToolTier tier, EnumFacing facing, int x) {
        if (facing == EnumFacing.NORTH) {
            return x - this.getSides(tier);
        }
        if (facing == EnumFacing.SOUTH) {
            return x - this.getSides(tier);
        }
        if (facing == EnumFacing.EAST) {
            return x - this.getFront(tier);
        }
        return x;
    }

    protected int getXPlus(ITiered.ToolTier tier, EnumFacing facing, int x) {
        if (facing == EnumFacing.NORTH) {
            return x + this.getSides(tier);
        }
        if (facing == EnumFacing.SOUTH) {
            return x + this.getSides(tier);
        }
        if (facing == EnumFacing.WEST) {
            return x + this.getFront(tier);
        }
        return x;
    }

    protected int getZMinus(ITiered.ToolTier tier, EnumFacing facing, int z) {
        if (facing == EnumFacing.SOUTH) {
            return z - this.getFront(tier);
        }
        if (facing == EnumFacing.WEST) {
            return z - this.getSides(tier);
        }
        if (facing == EnumFacing.EAST) {
            return z - this.getSides(tier);
        }
        return z;
    }

    protected int getZPlus(ITiered.ToolTier tier, EnumFacing facing, int z) {
        if (facing == EnumFacing.NORTH) {
            return z + this.getFront(tier);
        }
        if (facing == EnumFacing.WEST) {
            return z + this.getSides(tier);
        }
        if (facing == EnumFacing.EAST) {
            return z + this.getSides(tier);
        }
        return z;
    }

    protected void displayParticle(World world, BlockPos pos, EnumParticleTypes particle, IBlockState state) {
        int j = 0;
        while ((double)j < 60.0) {
            double d8 = (float)pos.func_177958_n() + world.field_73012_v.nextFloat();
            double d9 = (float)pos.func_177952_p() + world.field_73012_v.nextFloat();
            world.func_175688_a(particle, d8, (double)pos.func_177956_o() + 1.0 - 0.125, d9, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)state)});
            ++j;
        }
    }

    protected void playSound(World world, BlockPos pos, SoundEvent sound, SoundCategory category) {
        world.func_184133_a(null, pos, sound, category, world.field_73012_v.nextFloat() * 0.25f + 0.75f, world.field_73012_v.nextFloat() * 1.0f + 0.5f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < ITiered.ToolTier.values().length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    protected RayTraceResult getMovingObjectPositionFromPlayer(World world, EntityLivingBase entity) {
        float f = entity.field_70125_A;
        float f1 = entity.field_70177_z;
        double d0 = entity.field_70165_t;
        double d1 = entity.field_70163_u + (double)entity.func_70047_e();
        double d2 = entity.field_70161_v;
        Vec3d vec3 = new Vec3d(d0, d1, d2);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d3 = 5.0;
        if (entity instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)entity).field_71134_c.getBlockReachDistance();
        }
        Vec3d vec31 = vec3.func_72441_c((double)f6 * d3, (double)f5 * d3, (double)f7 * d3);
        return world.func_147447_a(vec3, vec31, false, false, false);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        switch (this.getTier(toRepair)) {
            case BASIC: {
                return InventoryHelper.ORE_DICTIONARY.matches(repair, "stone");
            }
            case COPPER: {
                return InventoryHelper.ITEM_STACK.matches(repair, HFMining.MATERIALS.getStackFromEnum(ItemMaterial.Material.COPPER));
            }
            case SILVER: {
                return InventoryHelper.ITEM_STACK.matches(repair, HFMining.MATERIALS.getStackFromEnum(ItemMaterial.Material.SILVER));
            }
            case GOLD: {
                return InventoryHelper.ITEM_STACK.matches(repair, HFMining.MATERIALS.getStackFromEnum(ItemMaterial.Material.GOLD));
            }
            case MYSTRIL: {
                return InventoryHelper.ITEM_STACK.matches(repair, HFMining.MATERIALS.getStackFromEnum(ItemMaterial.Material.MYSTRIL));
            }
            case MYTHIC: {
                return InventoryHelper.ITEM_STACK.matches(repair, HFMining.MATERIALS.getStackFromEnum(ItemMaterial.Material.MYTHIC));
            }
        }
        return false;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return this.toolClass != null ? ImmutableSet.of((Object)this.toolClass) : super.getToolClasses(stack);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        for (String type : this.getToolClasses(stack)) {
            if (!state.func_177230_c().isToolEffective(type, state)) continue;
            return this.getEffiency(stack);
        }
        return this.effectiveBlocks.contains(state.func_177230_c()) ? this.getEffiency(stack) : 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        if (advanced && HFCore.DEBUG_MODE) {
            tooltip.add("Durability: " + this.getDamageForDisplay(stack));
            tooltip.add("Level: " + this.getLevel(stack));
        }
    }
}

